/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.log4j.Logger;

public class JavaCompilerHelper {
    private static final Logger LOG = Logger.getLogger(JavaCompilerHelper.class);
    private String classPath = System.getProperty("java.class.path");

    public void compile(String target, JavaSourceFromString ... sources) {
        LOG.info((Object)("compiling java classes to " + target));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> optionList = Lists.newArrayList();
        optionList.add("-classpath");
        optionList.add(this.classPath);
        optionList.add("-d");
        optionList.add(target);
        if (!compiler.getTask(null, fileManager, diagnostics, optionList, null, Arrays.asList(sources)).call().booleanValue()) {
            LOG.warn((Object)"Error compiling Printing compilation errors and shutting down.");
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                LOG.warn((Object)("Error on line " + diagnostic.getLineNumber() + ": " + diagnostic.getMessage(Locale.US)));
            }
            throw new RuntimeException("Unable to compile");
        }
    }

    public void addToClassPath(String path) {
        this.classPath = this.classPath + System.getProperty("path.separator") + path;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;

        public JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

