/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Expression;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PColFilterExtractor
extends PlanVisitor {
    private static final Log LOG = LogFactory.getLog(PColFilterExtractor.class);
    private List<String> partitionCols;
    private ArrayList<Expression> pColConditions = new ArrayList();
    private boolean sawKey;
    private boolean sawNonKeyCol;
    private Side replaceSide = Side.NONE;
    private boolean filterRemovable = false;
    private boolean canPushDown = true;

    @Override
    public void visit() throws FrontendException {
        LogicalExpression leaf = (LogicalExpression)this.plan.getSources().get(0);
        if (leaf instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)leaf;
            this.visit(binExpr);
            this.replaceChild(binExpr);
            if (this.sawKey) {
                this.pColConditions.add(this.getExpression(leaf));
                this.filterRemovable = true;
            }
        }
    }

    public PColFilterExtractor(OperatorPlan plan, List<String> partitionCols) {
        super(plan, new DepthFirstWalker(plan));
        this.partitionCols = new ArrayList<String>(partitionCols);
    }

    protected void visit(ProjectExpression project) throws FrontendException {
        String fieldName = project.getFieldSchema().alias;
        if (this.partitionCols.contains(fieldName)) {
            this.sawKey = true;
            ArrayList opsToCheckFor = new ArrayList();
            opsToCheckFor.add(UserFuncExpression.class);
            if (this.checkSuccessors(project, opsToCheckFor)) {
                LOG.warn((Object)("No partition filter push down: You have an partition column (" + fieldName + ") inside a function in the " + "filter condition."));
                this.canPushDown = false;
                return;
            }
            opsToCheckFor.set(0, CastExpression.class);
            if (this.checkSuccessors(project, opsToCheckFor)) {
                LOG.warn((Object)("No partition filter push down: You have an partition column (" + fieldName + ") inside a cast in the " + "filter condition."));
                this.canPushDown = false;
                return;
            }
            opsToCheckFor.set(0, IsNullExpression.class);
            if (this.checkSuccessors(project, opsToCheckFor)) {
                LOG.warn((Object)("No partition filter push down: You have an partition column (" + fieldName + ") inside a null check operator in the " + "filter condition."));
                this.canPushDown = false;
                return;
            }
            opsToCheckFor.set(0, BinCondExpression.class);
            if (this.checkSuccessors(project, opsToCheckFor)) {
                LOG.warn((Object)("No partition filter push down: You have an partition column (" + fieldName + ") inside a bincond operator in the " + "filter condition."));
                this.canPushDown = false;
                return;
            }
        } else {
            this.sawNonKeyCol = true;
        }
    }

    private boolean detectNonPartitionColumn(BinaryExpression binOp) throws FrontendException {
        String fieldName;
        LogicalExpression lhs = binOp.getLhs();
        LogicalExpression rhs = binOp.getRhs();
        if (lhs instanceof ProjectExpression && !this.partitionCols.contains(fieldName = ((ProjectExpression)lhs).getFieldSchema().alias)) {
            return true;
        }
        if (rhs instanceof ProjectExpression && !this.partitionCols.contains(fieldName = ((ProjectExpression)rhs).getFieldSchema().alias)) {
            return true;
        }
        boolean lhsSawNonKeyCol = false;
        boolean rhsSawNonKeyCol = false;
        if (lhs instanceof BinaryExpression) {
            lhsSawNonKeyCol = this.detectNonPartitionColumn((BinaryExpression)lhs);
        }
        if (rhs instanceof BinaryExpression) {
            rhsSawNonKeyCol = this.detectNonPartitionColumn((BinaryExpression)rhs);
        }
        return lhsSawNonKeyCol || rhsSawNonKeyCol;
    }

    private boolean detectAndOrConditionWithMixedColumns(BinaryExpression binOp) throws FrontendException {
        LogicalExpression lhs = binOp.getLhs();
        LogicalExpression rhs = binOp.getRhs();
        if (binOp instanceof OrExpression && (lhs instanceof AndExpression && rhs instanceof AndExpression || lhs instanceof OrExpression || rhs instanceof OrExpression)) {
            return this.detectNonPartitionColumn(binOp);
        }
        return false;
    }

    private void visit(BinaryExpression binOp) throws FrontendException {
        boolean lhsSawKey = false;
        boolean rhsSawKey = false;
        boolean lhsSawNonKeyCol = false;
        boolean rhsSawNonKeyCol = false;
        this.sawKey = false;
        this.sawNonKeyCol = false;
        if (this.detectAndOrConditionWithMixedColumns(binOp)) {
            this.sawNonKeyCol = true;
            LOG.warn((Object)"No partition filter push down: You have partition and non-partition columns  in a construction like: (pcond and non-pcond ..) or (pcond and non-pcond ...) where pcond is a condition on a partition column and non-pcond is a condition on a non-partition column.");
            return;
        }
        this.visit(binOp.getLhs());
        this.replaceChild(binOp.getLhs());
        lhsSawKey = this.sawKey;
        lhsSawNonKeyCol = this.sawNonKeyCol;
        this.sawKey = false;
        this.sawNonKeyCol = false;
        this.visit(binOp.getRhs());
        this.replaceChild(binOp.getRhs());
        rhsSawKey = this.sawKey;
        rhsSawNonKeyCol = this.sawNonKeyCol;
        if (binOp instanceof AndExpression) {
            if (lhsSawKey && rhsSawNonKeyCol) {
                this.replaceSide = Side.LEFT;
            } else if (rhsSawKey && lhsSawNonKeyCol) {
                this.replaceSide = Side.RIGHT;
            }
        } else if (lhsSawKey && rhsSawNonKeyCol || rhsSawKey && lhsSawNonKeyCol) {
            LOG.warn((Object)"No partition filter push down: Use of partition column/condition with non partition column/condition in filter expression is not supported.");
            this.canPushDown = false;
        }
        this.sawKey = lhsSawKey || rhsSawKey;
        this.sawNonKeyCol = lhsSawNonKeyCol || rhsSawNonKeyCol;
    }

    public Expression getPColCondition() {
        if (!this.canPushDown || this.pColConditions.size() == 0) {
            return null;
        }
        Expression cond = this.pColConditions.get(0);
        for (int i = 1; i < this.pColConditions.size(); ++i) {
            cond = new Expression.BinaryExpression(cond, this.pColConditions.get(i), Expression.OpType.OP_AND);
        }
        return cond;
    }

    public boolean isFilterRemovable() {
        return this.canPushDown && this.filterRemovable;
    }

    private boolean checkSuccessors(Operator opToStartFrom, List<Class<?>> opsToCheckFor) throws FrontendException {
        boolean done = this.checkSuccessorsHelper(opToStartFrom, opsToCheckFor);
        if (!done && !opsToCheckFor.isEmpty()) {
            while (!done) {
                opToStartFrom = this.plan.getPredecessors(opToStartFrom).get(0);
                done = this.checkSuccessorsHelper(opToStartFrom, opsToCheckFor);
            }
        }
        return opsToCheckFor.isEmpty();
    }

    private boolean checkSuccessorsHelper(Operator opToStartFrom, List<Class<?>> opsToCheckFor) throws FrontendException {
        List<Operator> successors = this.plan.getPredecessors(opToStartFrom);
        if (successors == null || successors.size() == 0) {
            return true;
        }
        if (successors.size() == 1) {
            Operator suc = successors.get(0);
            if (suc.getClass().getCanonicalName().equals(opsToCheckFor.get(0).getCanonicalName())) {
                opsToCheckFor.remove(0);
                if (opsToCheckFor.isEmpty()) {
                    return true;
                }
            }
        } else {
            this.logInternalErrorAndSetFlag();
        }
        return false;
    }

    private void replaceChild(LogicalExpression childExpr) throws FrontendException {
        if (this.replaceSide == Side.NONE) {
            return;
        }
        if (!(childExpr instanceof BinaryExpression)) {
            this.logInternalErrorAndSetFlag();
            return;
        }
        LogicalExpression leftChild = ((BinaryExpression)childExpr).getLhs();
        LogicalExpression rightChild = ((BinaryExpression)childExpr).getRhs();
        this.plan.disconnect(childExpr, leftChild);
        this.plan.disconnect(childExpr, rightChild);
        if (this.replaceSide == Side.LEFT) {
            this.remove(leftChild);
            this.replace(childExpr, rightChild);
        } else if (this.replaceSide == Side.RIGHT) {
            this.remove(rightChild);
            this.replace(childExpr, leftChild);
        } else {
            this.logInternalErrorAndSetFlag();
            return;
        }
        this.replaceSide = Side.NONE;
        this.sawKey = false;
    }

    private void replace(Operator oldOp, Operator newOp) throws FrontendException {
        List<Operator> grandParents = this.plan.getPredecessors(oldOp);
        if (grandParents == null || grandParents.size() == 0) {
            this.plan.remove(oldOp);
            return;
        }
        Operator grandParent = this.plan.getPredecessors(oldOp).get(0);
        Pair<Integer, Integer> pair = this.plan.disconnect(grandParent, oldOp);
        this.plan.add(newOp);
        this.plan.connect(grandParent, (Integer)pair.first, newOp, (Integer)pair.second);
        this.plan.remove(oldOp);
    }

    private void remove(LogicalExpression op) throws FrontendException {
        this.pColConditions.add(this.getExpression(op));
        this.removeTree(op);
    }

    private void removeTree(Operator op) throws FrontendException {
        List<Operator> succs = this.plan.getSuccessors(op);
        if (succs == null) {
            this.plan.remove(op);
            return;
        }
        Operator[] children = new Operator[succs.size()];
        for (int i = 0; i < succs.size(); ++i) {
            children[i] = succs.get(i);
        }
        for (Operator succ : children) {
            this.plan.disconnect(op, succ);
            this.removeTree(succ);
        }
        this.plan.remove(op);
    }

    public Expression getExpression(LogicalExpression op) throws FrontendException {
        if (op instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)op;
            return new Expression.Const(constExpr.getValue());
        }
        if (op instanceof ProjectExpression) {
            ProjectExpression projExpr = (ProjectExpression)op;
            String fieldName = projExpr.getFieldSchema().alias;
            return new Expression.Column(fieldName);
        }
        if (!(op instanceof BinaryExpression)) {
            this.logInternalErrorAndSetFlag();
            return null;
        }
        BinaryExpression binOp = (BinaryExpression)op;
        if (binOp instanceof AddExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_PLUS);
        }
        if (binOp instanceof SubtractExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_MINUS);
        }
        if (binOp instanceof MultiplyExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_TIMES);
        }
        if (binOp instanceof DivideExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_DIV);
        }
        if (binOp instanceof ModExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_MOD);
        }
        if (binOp instanceof AndExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_AND);
        }
        if (binOp instanceof OrExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_OR);
        }
        if (binOp instanceof EqualExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_EQ);
        }
        if (binOp instanceof NotEqualExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_NE);
        }
        if (binOp instanceof GreaterThanExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_GT);
        }
        if (binOp instanceof GreaterThanEqualExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_GE);
        }
        if (binOp instanceof LessThanExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_LT);
        }
        if (binOp instanceof LessThanEqualExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_LE);
        }
        if (binOp instanceof RegexExpression) {
            return this.getExpression(binOp, Expression.OpType.OP_MATCH);
        }
        this.logInternalErrorAndSetFlag();
        return null;
    }

    private Expression getExpression(BinaryExpression binOp, Expression.OpType opType) throws FrontendException {
        return new Expression.BinaryExpression(this.getExpression(binOp.getLhs()), this.getExpression(binOp.getRhs()), opType);
    }

    private void logInternalErrorAndSetFlag() throws FrontendException {
        LOG.warn((Object)"No partition filter push down: Internal error while processing any partition filter conditions in the filter after the load");
        this.canPushDown = false;
    }

    private void visit(LogicalExpression op) throws FrontendException {
        if (op instanceof ProjectExpression) {
            this.visit((ProjectExpression)op);
        } else if (op instanceof BinaryExpression) {
            this.visit((BinaryExpression)op);
        } else if (op instanceof CastExpression) {
            this.visit((CastExpression)op);
        } else if (op instanceof BinCondExpression) {
            this.visit((BinCondExpression)op);
        } else if (op instanceof UserFuncExpression) {
            this.visit((UserFuncExpression)op);
        } else if (op instanceof IsNullExpression) {
            this.visit((IsNullExpression)op);
        } else if (op instanceof NotExpression) {
            this.visit((NotExpression)op);
        } else if (op instanceof RegexExpression) {
            this.visit((RegexExpression)op);
        } else if (op instanceof MapLookupExpression) {
            this.visit((MapLookupExpression)op);
        } else if (op instanceof DereferenceExpression) {
            this.visit((DereferenceExpression)op);
        }
    }

    private void visit(CastExpression cast) throws FrontendException {
        this.visit(cast.getExpression());
    }

    private void visit(NotExpression not) throws FrontendException {
        this.visit(not.getExpression());
    }

    private void visit(RegexExpression regexp) throws FrontendException {
        this.visit((BinaryExpression)regexp);
    }

    private void visit(BinCondExpression binCond) throws FrontendException {
        this.visit(binCond.getCondition());
        this.visit(binCond.getLhs());
        this.visit(binCond.getRhs());
    }

    private void visit(UserFuncExpression udf) throws FrontendException {
        for (LogicalExpression op : udf.getArguments()) {
            this.visit(op);
        }
    }

    private void visit(IsNullExpression isNull) throws FrontendException {
        this.visit(isNull.getExpression());
    }

    private void visit(MapLookupExpression mapLookup) throws FrontendException {
        this.visit(mapLookup.getMap());
    }

    private void visit(DereferenceExpression deref) throws FrontendException {
        this.visit(deref.getReferredExpression());
    }

    public boolean canPushDown() {
        return this.canPushDown;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Side {
        LEFT,
        RIGHT,
        NONE;

    }
}

