/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.pen.IllustratorAttacher;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Illustrator {
    private LineageTracer lineage;
    private LinkedList<IdentityHashSet<Tuple>> equivalenceClasses;
    private IdentityHashSet<Tuple> inputs = null;
    private DataBag data;
    private int maxRecords = -1;
    private int recCounter = 0;
    private IllustratorAttacher attacher;
    private ArrayList<Boolean[]> subExpResults;
    private Boolean[] subExpResult;
    private boolean eqClassesShared;
    private long oriLimit = -1L;
    private LogicalSchema schema;

    public Illustrator(LineageTracer lineage, LinkedList<IdentityHashSet<Tuple>> equivalenceClasses, IllustratorAttacher attacher, PigContext hadoopPigContext) {
        this.lineage = lineage;
        this.equivalenceClasses = equivalenceClasses;
        this.data = BagFactory.getInstance().newDefaultBag();
        this.attacher = attacher;
        this.subExpResults = new ArrayList();
        this.subExpResult = new Boolean[1];
        this.schema = null;
    }

    public Illustrator(LineageTracer lineage, LinkedList<IdentityHashSet<Tuple>> equivalenceClasses, int maxRecords, IllustratorAttacher attacher, LogicalSchema schema, PigContext hadoopPigContext) {
        this(lineage, equivalenceClasses, attacher, hadoopPigContext);
        this.maxRecords = maxRecords;
        this.schema = schema;
    }

    public ArrayList<Boolean[]> getSubExpResults() {
        return this.subExpResults;
    }

    Boolean[] getSubExpResult() {
        return this.subExpResult;
    }

    public LineageTracer getLineage() {
        return this.lineage;
    }

    public LinkedList<IdentityHashSet<Tuple>> getEquivalenceClasses() {
        return this.equivalenceClasses;
    }

    public void setSubExpResult(boolean result) {
        this.subExpResult[0] = result;
    }

    public void setEquivalenceClasses(LinkedList<IdentityHashSet<Tuple>> eqClasses, PhysicalOperator po) {
        this.equivalenceClasses = eqClasses;
        this.attacher.poToEqclassesMap.put(po, eqClasses);
    }

    public boolean ceilingCheck() {
        return this.maxRecords == -1 || ++this.recCounter <= this.maxRecords;
    }

    public IdentityHashSet<Tuple> getInputs() {
        return this.inputs;
    }

    public void addInputs(IdentityHashSet<Tuple> inputs) {
        if (this.inputs == null) {
            this.inputs = new IdentityHashSet();
        }
        this.inputs.addAll(inputs);
    }

    public void addData(Tuple t) {
        this.data.add(t);
    }

    public DataBag getData() {
        return this.data;
    }

    public long getOriginalLimit() {
        return this.oriLimit;
    }

    public void setOriginalLimit(long oriLimit) {
        this.oriLimit = oriLimit;
    }

    public void setEqClassesShared() {
        this.eqClassesShared = true;
    }

    public boolean getEqClassesShared() {
        return this.eqClassesShared;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }
}

