/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FixedWidthLoader
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private RecordReader reader = null;
    private ArrayList<FixedWidthField> columns;
    private ResourceSchema schema = null;
    private ResourceSchema.ResourceFieldSchema[] fields;
    private boolean loadingFirstRecord = true;
    private boolean skipHeader = false;
    private String header = null;
    private int splitIndex;
    private boolean[] requiredFields = null;
    private int numRequiredFields;
    private String udfContextSignature = null;
    private static final String SCHEMA_SIGNATURE = "pig.fixedwidthloader.schema";
    private static final String REQUIRED_FIELDS_SIGNATURE = "pig.fixedwidthloader.required_fields";
    private static final Log log = LogFactory.getLog(FixedWidthLoader.class);

    public FixedWidthLoader() {
        throw new IllegalArgumentException("Usage: org.apache.pig.piggybank.storage.FixedWidthLoader('<column spec>'[, { 'USE_HEADER' | 'SKIP_HEADER' }[, '<schema>']])");
    }

    public FixedWidthLoader(String columnSpec) {
        try {
            this.columns = FixedWidthLoader.parseColumnSpec(columnSpec);
            String schemaStr = this.generateDefaultSchemaString();
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)schemaStr));
            this.fields = this.schema.getFields();
        }
        catch (ParserException e) {
            throw new IllegalArgumentException("Invalid schema format: " + e.getMessage());
        }
    }

    public FixedWidthLoader(String columnSpec, String skipHeaderStr) {
        this(columnSpec);
        if (skipHeaderStr.equalsIgnoreCase("SKIP_HEADER")) {
            this.skipHeader = true;
        }
    }

    public FixedWidthLoader(String columnSpec, String skipHeaderStr, String schemaStr) {
        try {
            this.columns = FixedWidthLoader.parseColumnSpec(columnSpec);
            schemaStr = schemaStr.replaceAll("[\\s\\r\\n]", "");
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)schemaStr));
            this.fields = this.schema.getFields();
            for (int i = 0; i < this.fields.length; ++i) {
                byte fieldType = this.fields[i].getType();
                if (fieldType != 100 && fieldType != 110 && fieldType != 120) continue;
                throw new IllegalArgumentException("Field \"" + this.fields[i].getName() + "\" is an object type (map, tuple, or bag). " + "Object types are not supported by FixedWidthLoader.");
            }
            if (this.fields.length < this.columns.size()) {
                this.warn("More columns specified in column spec than fields specified in schema. Only loading fields specified in schema.", (Enum)PigWarning.UDF_WARNING_2);
            } else if (this.fields.length > this.columns.size()) {
                throw new IllegalArgumentException("More fields specified in schema than columns specified in column spec.");
            }
        }
        catch (ParserException e) {
            throw new IllegalArgumentException("Invalid schema format: " + e.getMessage());
        }
        if (skipHeaderStr.equalsIgnoreCase("SKIP_HEADER")) {
            this.skipHeader = true;
        }
    }

    public static ArrayList<FixedWidthField> parseColumnSpec(String spec) {
        String[] ranges;
        ArrayList<FixedWidthField> columns = new ArrayList<FixedWidthField>();
        for (String range : ranges = spec.split(",")) {
            if (range.indexOf("-") != -1) {
                String[] offsets = range.split("-", 2);
                offsets[0] = offsets[0].trim();
                offsets[1] = offsets[1].trim();
                int start = offsets[0].equals("") ? 0 : Integer.parseInt(offsets[0]) - 1;
                int end = offsets[1].equals("") ? Integer.MAX_VALUE : Integer.parseInt(offsets[1]);
                if (start + 1 < 1) {
                    throw new IllegalArgumentException("Illegal column spec '" + range + "': start value must be at least 1");
                }
                if (start + 1 > end) {
                    throw new IllegalArgumentException("Illegal column spec '" + range + "': start value must be less than end value");
                }
                columns.add(new FixedWidthField(start, end));
                continue;
            }
            int offset = Integer.parseInt(range.trim()) - 1;
            columns.add(new FixedWidthField(offset, offset + 1));
        }
        return columns;
    }

    private String generateDefaultSchemaString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append((i == 0 ? "" : ", ") + "f" + i + ": bytearray");
        }
        return sb.toString();
    }

    public InputFormat getInputFormat() throws IOException {
        return new TextInputFormat();
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public void setUDFContextSignature(String signature) {
        this.udfContextSignature = signature;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.schema != null) {
            UDFContext udfc = UDFContext.getUDFContext();
            Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
            p.setProperty(SCHEMA_SIGNATURE, this.schema.toString());
            return this.schema;
        }
        throw new IllegalArgumentException("No schema found: default schema was never created and no user-specified schema was found.");
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
        this.splitIndex = split.getSplitIndex();
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        this.requiredFields = (boolean[])ObjectSerializer.deserialize((String)p.getProperty(REQUIRED_FIELDS_SIGNATURE));
        if (this.requiredFields != null) {
            this.numRequiredFields = 0;
            for (int i = 0; i < this.requiredFields.length; ++i) {
                if (!this.requiredFields[i]) continue;
                ++this.numRequiredFields;
            }
        }
    }

    public Tuple getNext() throws IOException {
        Tuple t;
        String line;
        if (this.loadingFirstRecord && this.skipHeader && this.splitIndex == 0) {
            try {
                if (!this.reader.nextKeyValue()) {
                    return null;
                }
                this.header = ((Text)this.reader.getCurrentValue()).toString();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.loadingFirstRecord = false;
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            line = ((Text)this.reader.getCurrentValue()).toString();
            if (line.equals(this.header)) {
                if (!this.reader.nextKeyValue()) {
                    return null;
                }
                line = ((Text)this.reader.getCurrentValue()).toString();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (this.requiredFields != null) {
            t = this.tupleFactory.newTuple(this.numRequiredFields);
            int count = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                if (!this.requiredFields[i]) continue;
                try {
                    t.set(count, this.readField(line, this.fields[i], this.columns.get(i)));
                }
                catch (Exception e) {
                    this.warn("Exception when parsing field \"" + this.fields[i].getName() + "\" " + "in record " + line.toString() + ": " + e.toString(), (Enum)PigWarning.UDF_WARNING_1);
                }
                ++count;
            }
        } else {
            t = this.tupleFactory.newTuple(this.fields.length);
            for (int i = 0; i < this.fields.length; ++i) {
                try {
                    t.set(i, this.readField(line, this.fields[i], this.columns.get(i)));
                    continue;
                }
                catch (Exception e) {
                    this.warn("Exception when parsing field \"" + this.fields[i].getName() + "\" " + "in record " + line.toString() + ": " + e.toString(), (Enum)PigWarning.UDF_WARNING_1);
                }
            }
        }
        return t;
    }

    private Object readField(String line, ResourceSchema.ResourceFieldSchema field, FixedWidthField column) throws IOException, IllegalArgumentException {
        int start = column.start;
        int end = Math.min(column.end, line.length());
        if (start > line.length()) {
            return null;
        }
        if (end <= start) {
            return null;
        }
        String s = line.substring(start, end);
        String sTrim = s.trim();
        switch (field.getType()) {
            case 0: 
            case 50: 
            case 55: {
                if (s.trim().length() == 0) {
                    return null;
                }
                return s.trim();
            }
            case 5: {
                return Boolean.parseBoolean(sTrim);
            }
            case 10: {
                return Integer.parseInt(sTrim);
            }
            case 15: {
                return Long.parseLong(sTrim);
            }
            case 20: {
                return Float.valueOf(Float.parseFloat(sTrim));
            }
            case 25: {
                return Double.parseDouble(sTrim);
            }
            case 30: {
                return new DateTime((Object)sTrim).toDateTime(DateTimeZone.UTC);
            }
            case 100: 
            case 110: 
            case 120: {
                throw new IllegalArgumentException("Object types (map, tuple, bag) are not supported by FixedWidthLoader");
            }
        }
        throw new IllegalArgumentException("Unknown type in input schema: " + field.getType());
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (this.fields != null && requiredFieldList.getFields() != null) {
            this.requiredFields = new boolean[this.fields.length];
            for (LoadPushDown.RequiredField f : requiredFieldList.getFields()) {
                this.requiredFields[f.getIndex()] = true;
            }
            UDFContext udfc = UDFContext.getUDFContext();
            Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
            try {
                p.setProperty(REQUIRED_FIELDS_SIGNATURE, ObjectSerializer.serialize((Serializable)this.requiredFields));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize requiredFields for pushProjection");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    public static class FixedWidthField {
        int start;
        int end;

        FixedWidthField(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

