/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import java.util.LinkedList;
import java.util.Properties;
import org.talend.sap.ISAPConnection;
import org.talend.sap.ISAPConnectionMetadata;
import org.talend.sap.ISAPTransaction;
import org.talend.sap.impl.SAPConnectionMetadata;
import org.talend.sap.impl.SAPTransaction;
import org.talend.sap.impl.service.SAPBapiMetadataService;
import org.talend.sap.impl.service.SAPBapiService;
import org.talend.sap.impl.service.SAPTableDataService;
import org.talend.sap.impl.service.SAPTableMetadataService;
import org.talend.sap.service.ISAPBapiMetadataService;
import org.talend.sap.service.ISAPBapiService;
import org.talend.sap.service.ISAPTableDataService;
import org.talend.sap.service.ISAPTableMetadataService;

public class SAPConnection
implements ISAPConnection {
    private final JCoDestination destination;
    private final JCoRepository repository;
    private final ThreadLocal<ISAPTransaction> transactions;
    private ISAPConnectionMetadata metadata;
    private ISAPBapiMetadataService bapiMetadataService;
    private ISAPBapiService bapiService;
    private ISAPTableDataService tableDataService;
    private ISAPTableMetadataService tableMetadataService;

    public SAPConnection(JCoDestination destination) throws JCoException {
        this(destination, destination.getRepository());
    }

    public SAPConnection(JCoDestination destination, JCoRepository repository) {
        this.destination = destination;
        this.repository = repository;
        this.transactions = new ThreadLocal();
        this.init();
    }

    protected void init() {
        this.metadata = new SAPConnectionMetadata(this.destination);
        this.bapiMetadataService = new SAPBapiMetadataService(this);
        this.bapiService = new SAPBapiService(this);
        this.tableDataService = new SAPTableDataService(this);
        this.tableMetadataService = new SAPTableMetadataService(this);
    }

    public synchronized ISAPTransaction beginTransaction() {
        ISAPTransaction transaction = this.transactions.get();
        if (transaction == null || !transaction.isAlive()) {
            transaction = new SAPTransaction(this.destination, this.repository);
            this.transactions.set(transaction);
            return transaction;
        }
        return null;
    }

    public void close() {
    }

    public ISAPBapiMetadataService getBapiMetadataService() {
        return this.bapiMetadataService;
    }

    public ISAPBapiService getBapiService() {
        return this.bapiService;
    }

    public JCoDestination getDestination() {
        return this.destination;
    }

    public ISAPConnectionMetadata getMetadata() {
        return this.metadata;
    }

    public Properties getProperties() {
        return this.destination != null ? this.destination.getProperties() : new Properties();
    }

    public JCoRepository getRepository() {
        return this.repository;
    }

    public ISAPTableDataService getTableDataService() {
        return this.tableDataService;
    }

    public ISAPTableMetadataService getTableMetadataService() {
        return this.tableMetadataService;
    }

    public ISAPTransaction getTransaction() {
        ISAPTransaction transaction = this.transactions.get();
        return transaction.isAlive() ? transaction : null;
    }

    public boolean isAlive() {
        try {
            this.destination.ping();
        }
        catch (JCoException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getSimpleName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" [\n");
        Properties props = this.destination.getProperties();
        LinkedList<String> propertyNames = new LinkedList<String>(props.stringPropertyNames());
        for (int i = 0; i < propertyNames.size(); ++i) {
            sb.append("  ");
            sb.append(i == 0 ? " " : ",");
            sb.append((String)propertyNames.get(i));
            sb.append("=");
            sb.append(props.getProperty((String)propertyNames.get(i)));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

