/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Properties;
import org.talend.sap.ISAPConnection;
import org.talend.sap.ISAPConnectionFactory;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPConnectionDataProvider;
import org.talend.sap.impl.SAPUtil;

public class SAPConnectionFactory
implements ISAPConnectionFactory {
    private static final ISAPConnectionFactory INSTANCE = new SAPConnectionFactory();
    private static final SAPConnectionDataProvider CONNECTION_DATA_PROVIDER = new SAPConnectionDataProvider();

    public static ISAPConnectionFactory getInstance() {
        return INSTANCE;
    }

    protected SAPConnectionFactory() {
    }

    public synchronized ISAPConnection createConnection(Properties properties) throws SAPException {
        if (properties == null) {
            throw new IllegalArgumentException("The given connection properties are null.");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("The given properties are empty.");
        }
        String destinationName = this.addDestinationProperties(properties);
        SAPConnection connection = null;
        try {
            connection = new SAPConnection(JCoDestinationManager.getDestination((String)destinationName));
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(0).build();
        }
        catch (JCoRuntimeException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(0).build();
        }
        return connection;
    }

    public void setMiddleWareProperties(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            JCo.setMiddlewareProperty((String)key, (String)properties.getProperty(key));
        }
    }

    public void setTrace(int level, String filePath) {
        JCo.setTrace((int)level, (String)filePath);
    }

    protected String addDestinationProperties(Properties properties) {
        return CONNECTION_DATA_PROVIDER.addDestinationProperties(properties);
    }

    static {
        Environment.registerDestinationDataProvider((DestinationDataProvider)CONNECTION_DATA_PROVIDER);
    }
}

