/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import org.talend.sap.ISAPTransaction;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPUtil;

public class SAPTransaction
implements ISAPTransaction {
    private final JCoDestination destination;
    private final JCoRepository repository;
    private boolean isAlive;

    protected SAPTransaction(JCoDestination destination, JCoRepository repository) {
        this.destination = destination;
        this.repository = repository;
        this.init();
    }

    protected void init() {
        this.isAlive = true;
        this.beginCallSequence();
    }

    public void commit() throws SAPException {
        this.endCallSequence("BAPI_TRANSACTION_COMMIT");
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void rollback() throws SAPException {
        this.endCallSequence("BAPI_TRANSACTION_ROLLBACK");
    }

    protected void beginCallSequence() {
        JCoContext.begin((JCoDestination)this.destination);
    }

    protected void endCallSequence(String commitOrRollback) throws SAPException {
        this.isAlive = false;
        try {
            this.repository.getFunction(commitOrRollback).execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(3).bapiName(commitOrRollback).build();
        }
        try {
            JCoContext.end((JCoDestination)this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(3).build();
        }
    }
}

