/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import java.util.HashMap;
import java.util.Map;
import org.talend.sap.exception.SAPException;
import org.talend.sap.model.SAPTableType;
import org.talend.sap.model.SAPType;

public class SAPUtil {
    private static final String INVALID_DATE_VALUE = "0000-00-00";
    private static final String INVALID_TIME_VALUE = "00:00:00";
    private static final Map<String, SAPType> FIELD_TYPE_MAPPING = new HashMap<String, SAPType>();
    private static final Map<Integer, SAPType> PARAMETER_TYPE_MAPPING;
    private static final Map<String, SAPTableType> TABLE_TYPE_MAPPING;
    private static final Map<SAPType, String> XSD_TYPE_MAPPING;

    public static SAPException.Builder createExceptionBuilder(JCoException e) {
        return SAPException.newBuilder().errorGroup(e.getGroup()).errorKey(e.getKey()).errorMessage(e.getMessage()).errorMessageClass(e.getMessageClass()).errorMessageNumber(e.getMessageNumber()).errorMessageText(e.getMessageText()).errorMessageType(e.getMessageType());
    }

    public static SAPException.Builder createExceptionBuilder(JCoRuntimeException e) {
        return SAPException.newBuilder().errorGroup(e.getGroup()).errorKey(e.getKey()).errorMessage(e.getMessage());
    }

    public static String extractFieldData(String wa, String fieldName, Map<String, Integer> offsetIndex, Map<String, Integer> lengthIndex) {
        return SAPUtil.extractFieldData(wa, offsetIndex.get(fieldName), lengthIndex.get(fieldName));
    }

    public static String extractFieldData(String wa, int offset, int length) {
        if (offset > wa.length()) {
            return null;
        }
        return wa.substring(offset, offset + (offset + length > wa.length() ? wa.length() - offset : length)).trim();
    }

    public static SAPType getFieldType(String value) {
        return FIELD_TYPE_MAPPING.get(value);
    }

    public static SAPType getParameterType(int jcoType) {
        return PARAMETER_TYPE_MAPPING.get(jcoType);
    }

    public static SAPTableType getTableType(String value) {
        return TABLE_TYPE_MAPPING.get(value);
    }

    public static String getXsdType(int jcoType) {
        SAPType type = SAPUtil.getParameterType(jcoType);
        return type != null ? XSD_TYPE_MAPPING.get(type) : null;
    }

    public static boolean isConditionTooLong(JCoException e) {
        return e.getGroup() == 104 && e.getMessageNumber().equals("341");
    }

    public static boolean isEmptyDateOrTime(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    public static boolean isInvalidDate(String value) {
        return INVALID_DATE_VALUE.equals(value);
    }

    public static boolean isInvalidTime(String value) {
        return INVALID_TIME_VALUE.equals(value);
    }

    public static String replaceNamespace(String name) {
        return name.replace("/", "_-");
    }

    public static String resolveNamespace(String name) {
        return name.replace("_-", "/");
    }

    static {
        FIELD_TYPE_MAPPING.put("a", SAPType.BIG_DECIMAL);
        FIELD_TYPE_MAPPING.put("e", SAPType.BIG_DECIMAL);
        FIELD_TYPE_MAPPING.put("P", SAPType.BIG_DECIMAL);
        FIELD_TYPE_MAPPING.put("N", SAPType.BIG_INTEGER);
        FIELD_TYPE_MAPPING.put("b", SAPType.BYTE);
        FIELD_TYPE_MAPPING.put("D", SAPType.DATE);
        FIELD_TYPE_MAPPING.put("F", SAPType.DOUBLE);
        FIELD_TYPE_MAPPING.put("I", SAPType.INTEGER);
        FIELD_TYPE_MAPPING.put("X", SAPType.RAW);
        FIELD_TYPE_MAPPING.put("s", SAPType.SHORT);
        FIELD_TYPE_MAPPING.put("C", SAPType.STRING);
        FIELD_TYPE_MAPPING.put("T", SAPType.TIME);
        PARAMETER_TYPE_MAPPING = new HashMap<Integer, SAPType>();
        PARAMETER_TYPE_MAPPING.put(2, SAPType.BIG_DECIMAL);
        PARAMETER_TYPE_MAPPING.put(4, SAPType.RAW);
        PARAMETER_TYPE_MAPPING.put(0, SAPType.STRING);
        PARAMETER_TYPE_MAPPING.put(1, SAPType.DATE);
        PARAMETER_TYPE_MAPPING.put(23, SAPType.BIG_DECIMAL);
        PARAMETER_TYPE_MAPPING.put(24, SAPType.BIG_DECIMAL);
        PARAMETER_TYPE_MAPPING.put(7, SAPType.DOUBLE);
        PARAMETER_TYPE_MAPPING.put(8, SAPType.INTEGER);
        PARAMETER_TYPE_MAPPING.put(10, SAPType.BYTE);
        PARAMETER_TYPE_MAPPING.put(9, SAPType.SHORT);
        PARAMETER_TYPE_MAPPING.put(6, SAPType.BIG_INTEGER);
        PARAMETER_TYPE_MAPPING.put(29, SAPType.STRING);
        PARAMETER_TYPE_MAPPING.put(3, SAPType.TIME);
        PARAMETER_TYPE_MAPPING.put(30, SAPType.RAW);
        TABLE_TYPE_MAPPING = new HashMap<String, SAPTableType>();
        TABLE_TYPE_MAPPING.put("APPEND", SAPTableType.APPEND_STRUCTURE);
        TABLE_TYPE_MAPPING.put("CLUSTER", SAPTableType.CLUSTER);
        TABLE_TYPE_MAPPING.put("POOL", SAPTableType.POOL);
        TABLE_TYPE_MAPPING.put("INTTAB", SAPTableType.STRUCTURE);
        TABLE_TYPE_MAPPING.put("TRANSP", SAPTableType.TRANSPARENT);
        TABLE_TYPE_MAPPING.put("VIEW", SAPTableType.VIEW);
        XSD_TYPE_MAPPING = new HashMap<SAPType, String>();
        XSD_TYPE_MAPPING.put(SAPType.BIG_DECIMAL, "xs:decimal");
        XSD_TYPE_MAPPING.put(SAPType.BIG_INTEGER, "xs:long");
        XSD_TYPE_MAPPING.put(SAPType.BYTE, "xs:unsignedByte");
        XSD_TYPE_MAPPING.put(SAPType.DATE, "xs:date");
        XSD_TYPE_MAPPING.put(SAPType.DOUBLE, "xs:double");
        XSD_TYPE_MAPPING.put(SAPType.INTEGER, "xs:integer");
        XSD_TYPE_MAPPING.put(SAPType.RAW, "xs:base64Binary");
        XSD_TYPE_MAPPING.put(SAPType.SHORT, "xs:short");
        XSD_TYPE_MAPPING.put(SAPType.STRING, "xs:string");
        XSD_TYPE_MAPPING.put(SAPType.TIME, "xs:time");
    }
}

