/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.model.bapi;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.util.Codecs;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.tree.DefaultText;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.model.bapi.parameter.SAPParameterListType;
import org.talend.sap.model.bapi.ISAPBapiTemplate;

public class SAPBapiTemplate
implements ISAPBapiTemplate {
    private final SAPConnection connection;
    private final JCoFunction function;

    public SAPBapiTemplate(SAPConnection connection, JCoFunction function) {
        this.connection = connection;
        this.function = function;
    }

    public Document execute() throws SAPException {
        try {
            this.function.execute(this.connection.getDestination());
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(22).bapiName("RFC_READ_TABLE").build();
        }
        return this.toXml();
    }

    public JCoFunction getFunction() {
        return this.function;
    }

    public String getName() {
        return this.function.getName();
    }

    public void setXml(Document document) throws SAPException {
        this.processXmlRoot(document);
    }

    protected void processParameterList(SAPParameterListType parameterListType, Element root) {
        DOMElement element = new DOMElement(parameterListType.tagName());
        JCoParameterList parameterList = null;
        switch (parameterListType) {
            case CHANGING: {
                parameterList = this.function.getChangingParameterList();
                break;
            }
            case EXPORT: {
                parameterList = this.function.getExportParameterList();
                break;
            }
            case TABLES: {
                parameterList = this.function.getTableParameterList();
                break;
            }
        }
        if (parameterList != null) {
            root.add((Element)element);
            this.processRecord((JCoRecord)parameterList, (Element)element);
        }
    }

    protected void processRecord(JCoRecord record, Element parent) {
        if (record == null) {
            return;
        }
        JCoMetaData recordMetaData = record.getMetaData();
        for (int i = 0; i < recordMetaData.getFieldCount(); ++i) {
            String recordName = recordMetaData.getName(i);
            DOMElement element = new DOMElement(SAPUtil.replaceNamespace(recordName));
            if (recordMetaData.isStructure(i)) {
                parent.add((Element)element);
                this.processRecord((JCoRecord)record.getStructure(recordName), (Element)element);
                continue;
            }
            if (recordMetaData.isTable(i)) {
                parent.add((Element)element);
                JCoTable table = record.getTable(recordName);
                for (int j = 0; j < table.getNumRows(); ++j) {
                    table.setRow(j);
                    DOMElement item = new DOMElement("item");
                    element.add((Element)item);
                    this.processRecord((JCoRecord)table, (Element)item);
                }
                continue;
            }
            if (!record.isInitialized(recordName)) continue;
            String text = record.toXML(recordName);
            if (recordMetaData.getType(recordName) == 1) {
                if (SAPUtil.isInvalidDate(text)) continue;
                element.setText(text);
                parent.add((Element)element);
                continue;
            }
            if (recordMetaData.getType(recordName) == 3) {
                if (SAPUtil.isInvalidTime(text)) continue;
                element.setText(text);
                parent.add((Element)element);
                continue;
            }
            if (text.isEmpty()) continue;
            if (recordMetaData.getType(recordName) == 29 || recordMetaData.getType(recordName) == 0) {
                element.add((CDATA)new DOMCDATA(text));
            } else {
                element.setText(text);
            }
            parent.add((Element)element);
        }
    }

    protected void processXmlRoot(Document document) throws SAPException {
        Element rootElement = document.getRootElement();
        for (int i = 0; i < rootElement.nodeCount(); ++i) {
            Node node = rootElement.node(i);
            if (node instanceof DefaultText) continue;
            String tagName = node.getName();
            try {
                switch (SAPParameterListType.getByTagName(tagName)) {
                    case IMPORT: {
                        this.processXmlNode((Node)((Element)node), (JCoRecord)this.function.getImportParameterList());
                        break;
                    }
                    case TABLES: {
                        this.processXmlNode((Node)((Element)node), (JCoRecord)this.function.getTableParameterList());
                        break;
                    }
                    case CHANGING: {
                        this.processXmlNode((Node)((Element)node), (JCoRecord)this.function.getChangingParameterList());
                        break;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                throw SAPException.newBuilder().errorCode(23).errorMessage(String.format("Encountered unknown parameter type %s under XML root.", tagName)).bapiName(this.function.getName()).build();
            }
        }
    }

    protected void processXmlNode(Node ancestorNode, JCoRecord record) throws SAPException {
        if (!(ancestorNode instanceof Element)) {
            throw SAPException.newBuilder().errorCode(23).errorMessage(String.format("Encountered node that should be an element node: %s", ancestorNode.getName())).bapiName(this.function.getName()).build();
        }
        JCoMetaData recordMetaData = record.getMetaData();
        for (int i = 0; i < ((Element)ancestorNode).nodeCount(); ++i) {
            Node node = ((Element)ancestorNode).node(i);
            if (node instanceof DefaultText) continue;
            String nodeName = node.getName();
            if (nodeName.charAt(0) == '_') {
                nodeName = SAPUtil.resolveNamespace(nodeName);
            }
            if (!recordMetaData.hasField(nodeName)) {
                throw SAPException.newBuilder().errorCode(21).errorMessage(String.format("Encountered unknown parameter or field for node: %s", node.getName())).bapiName(this.function.getName()).build();
            }
            if (recordMetaData.isTable(nodeName)) {
                JCoTable table = record.getTable(nodeName);
                for (int j = 0; j < ((Element)node).nodeCount(); ++j) {
                    Node child = ((Element)node).node(j);
                    if (child instanceof DefaultText) continue;
                    table.appendRow();
                    this.processXmlNode(child, (JCoRecord)table);
                }
                continue;
            }
            if (recordMetaData.isStructure(nodeName)) {
                this.processXmlNode(node, (JCoRecord)record.getStructure(nodeName));
                continue;
            }
            try {
                if (recordMetaData.getType(nodeName) == 4 || recordMetaData.getType(nodeName) == 30) {
                    record.setValue(nodeName, Codecs.Base64.decode((String)node.getText()));
                    continue;
                }
                record.setValue(nodeName, node.getText());
                continue;
            }
            catch (JCoRuntimeException e) {
                throw SAPUtil.createExceptionBuilder(e).errorCode(23).errorMessage(String.format("Value '%s' of node '%s' could not be converted to JCo internal format.", node.getText(), nodeName)).bapiName(this.function.getName()).build();
            }
        }
    }

    protected Document toXml() {
        DOMDocument document = new DOMDocument();
        document.add((Element)new DOMElement(SAPUtil.replaceNamespace(this.function.getName())));
        this.processParameterList(SAPParameterListType.CHANGING, document.getRootElement());
        this.processParameterList(SAPParameterListType.EXPORT, document.getRootElement());
        this.processParameterList(SAPParameterListType.TABLES, document.getRootElement());
        return document;
    }
}

