/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.model.table;

import com.sap.conn.jco.JCoTable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.model.SAPType;
import org.talend.sap.model.table.ISAPTableData;
import org.talend.sap.model.table.ISAPTableField;

public class SAPTableData
implements ISAPTableData {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private final DateFormat timeFormat = new SimpleDateFormat("HHmmSS");
    private final JCoTable data;
    private int rowPointer;
    private List<ISAPTableField> fieldList;
    private Map<String, ISAPTableField> fieldIndex;
    private Map<String, Integer> lengthIndex;
    private Map<String, Integer> offsetIndex;
    private Map<String, String> values;

    public SAPTableData(JCoTable data) {
        this.data = data;
        this.rowPointer = -1;
    }

    public void firstRow() {
        if (!this.isEmpty()) {
            this.setRow(0);
        }
    }

    public int getColumnCount() {
        return this.fieldList.size();
    }

    public ISAPTableField getField(int columnIndex) {
        return this.fieldList.get(columnIndex);
    }

    public int getRowCount() {
        return this.data.getNumRows();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean isFirstRow() {
        return this.data.isFirstRow();
    }

    public boolean isLastRow() {
        return this.data.isLastRow();
    }

    public void lastRow() {
        if (!this.isEmpty()) {
            this.setRow(this.data.getNumRows() - 1);
        }
    }

    public boolean nextRow() {
        if (this.isEmpty() || this.rowPointer == this.data.getNumRows() - 1) {
            return false;
        }
        this.setRow(this.rowPointer + 1);
        return true;
    }

    public void setRow(int rowIndex) {
        this.rowPointer = rowIndex;
        this.data.setRow(rowIndex);
        this.values.clear();
        String wa = this.data.getString(0);
        for (ISAPTableField field : this.fieldList) {
            String value = SAPUtil.extractFieldData(wa, field.getName(), this.offsetIndex, this.lengthIndex);
            if (value.isEmpty()) continue;
            if (field.getType() == SAPType.DATE || field.getType() == SAPType.TIME) {
                if (SAPUtil.isEmptyDateOrTime(value)) continue;
                this.values.put(field.getName(), value);
                continue;
            }
            this.values.put(field.getName(), value);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SAPException {
        return this.getBigDecimal(this.fieldList.get(columnIndex).getName());
    }

    public BigDecimal getBigDecimal(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public BigInteger getBigInteger(int columnIndex) throws SAPException {
        return this.getBigInteger(this.fieldList.get(columnIndex).getName());
    }

    public BigInteger getBigInteger(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return new BigInteger(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Byte getByte(int columnIndex) throws SAPException {
        return this.getByte(this.fieldList.get(columnIndex).getName());
    }

    public Byte getByte(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Date getDate(int columnIndex) throws SAPException {
        return this.getDate(this.fieldList.get(columnIndex).getName());
    }

    public Date getDate(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Double getDouble(int columnIndex) throws SAPException {
        return this.getDouble(this.fieldList.get(columnIndex).getName());
    }

    public Double getDouble(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Float getFloat(int columnIndex) throws SAPException {
        return this.getFloat(this.fieldList.get(columnIndex).getName());
    }

    public Float getFloat(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Integer getInteger(int columnIndex) throws SAPException {
        return this.getInteger(this.fieldList.get(columnIndex).getName());
    }

    public Integer getInteger(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public Long getLong(int columnIndex) throws SAPException {
        return this.getLong(this.fieldList.get(columnIndex).getName());
    }

    public Long getLong(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public byte[] getRaw(int columnIndex) throws SAPException {
        return this.getRaw(this.fieldList.get(columnIndex).getName());
    }

    public byte[] getRaw(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        return value != null ? value.getBytes() : null;
    }

    public Short getShort(int columnIndex) throws SAPException {
        return this.getShort(this.fieldList.get(columnIndex).getName());
    }

    public Short getShort(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return Short.valueOf(this.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    public String getString(int columnIndex) throws SAPException {
        return this.getString(this.fieldList.get(columnIndex).getName());
    }

    public String getString(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        return value != null ? value : null;
    }

    public Date getTime(int columnIndex) throws SAPException {
        return this.getTime(this.fieldList.get(columnIndex).getName());
    }

    public Date getTime(String columnName) throws SAPException {
        String value = this.getValue(columnName);
        if (value == null) {
            return null;
        }
        try {
            return this.timeFormat.parse(value);
        }
        catch (ParseException e) {
            throw this.newParseException(columnName, value, e.getMessage());
        }
    }

    protected String getValue(String columnName) {
        return this.values.get(columnName);
    }

    public boolean isNull(int columnIndex) throws SAPException {
        return this.isNull(this.fieldList.get(columnIndex).getName());
    }

    public boolean isNull(String columnName) throws SAPException {
        return this.getValue(columnName) == null;
    }

    protected SAPException newParseException(String columnName, String columnValue, String message) {
        return SAPException.newBuilder().errorMessage(String.format("Value '%s' of field '%s' could not be parsed: %s", columnValue, columnName, message)).build();
    }

    public void setFieldList(List<ISAPTableField> fieldList) {
        this.fieldList = fieldList;
        this.fieldIndex = new HashMap<String, ISAPTableField>();
        this.values = new HashMap<String, String>(fieldList.size(), 1.0f);
        for (ISAPTableField field : fieldList) {
            this.fieldIndex.put(field.getName(), field);
        }
    }

    public void setLengthIndex(Map<String, Integer> lengthIndex) {
        this.lengthIndex = lengthIndex;
    }

    public void setOffsetIndex(Map<String, Integer> offsetIndex) {
        this.offsetIndex = offsetIndex;
    }

    protected String toNumericString(String value) {
        if (value.charAt(value.length() - 1) == '-') {
            return new StringBuilder(value.length()).append('-').append(value.substring(0, value.length() - 1)).toString();
        }
        return value;
    }
}

