/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;

public abstract class AbstractSAPService {
    protected final SAPConnection connection;
    protected final JCoDestination destination;
    protected final JCoRepository repository;

    protected AbstractSAPService(SAPConnection connection) {
        if (connection != null) {
            this.connection = connection;
            this.destination = connection.getDestination();
            this.repository = connection.getRepository();
        } else {
            this.connection = null;
            this.destination = null;
            this.repository = null;
        }
    }

    protected JCoFunction getFunction(String functionName) throws SAPException {
        try {
            return this.repository.getFunction(functionName);
        }
        catch (JCoException e) {
            int errorCode = e.getGroup() == 123 ? 20 : 1;
            throw SAPUtil.createExceptionBuilder(e).errorCode(errorCode).bapiName(functionName).build();
        }
    }

    protected boolean isAll(String condition) {
        return condition == null || condition.isEmpty() || condition.equals("*");
    }

    protected boolean isTrue(String value) {
        return "X".equals(value);
    }
}

