/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.model.table.SAPTableData;
import org.talend.sap.impl.model.table.SAPTableField;
import org.talend.sap.impl.service.AbstractSAPTableService;
import org.talend.sap.model.table.ISAPTableData;
import org.talend.sap.model.table.ISAPTableField;
import org.talend.sap.service.ISAPTableDataService;

public class SAPTableDataService
extends AbstractSAPTableService
implements ISAPTableDataService {
    private static final int FIELD_LIST_SIZE = 1024;
    private static final String TOKEN_AND = " and ";
    private static final String TOKEN_OR = " or ";
    private final boolean useCustomFunction = this.useCustomFunction();

    public SAPTableDataService(SAPConnection connection) {
        super(connection);
    }

    public ISAPTableData getTableData(String tableName, List<String> fieldNames, String condition) throws SAPException {
        return this.getTableData(tableName, fieldNames, condition, null);
    }

    public ISAPTableData getTableData(String tableName, List<String> fieldNames, String condition, Integer maxRows) throws SAPException {
        return this.getTableData(tableName, fieldNames, condition, maxRows, null);
    }

    public ISAPTableData getTableData(String tableName, List<String> fieldNames, String condition, Integer maxRows, Integer skipCount) throws SAPException {
        if (tableName == null) {
            throw new IllegalArgumentException("The given table name is null.");
        }
        if (tableName.isEmpty()) {
            throw new IllegalArgumentException("The given table name is empty.");
        }
        String functionName = this.useCustomFunction ? "Z_TALEND_READ_TABLE" : "RFC_READ_TABLE";
        JCoFunction function = this.getFunction(functionName);
        this.setQueryTable(function, tableName);
        this.setFields(function, fieldNames);
        this.setWhereClause(function, condition);
        this.setMaxRows(function, maxRows);
        this.setSkipCount(function, skipCount);
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            int errorCode = e.getKey().equals("DATA_BUFFER_EXCEEDED") ? 13 : (e.getKey().equals("FIELD_NOT_VALID") ? 11 : (e.getKey().equals("NOT_AUTHORIZED") ? 2 : (e.getKey().equals("OPTION_NOT_VALID") || SAPUtil.isConditionTooLong(e) ? 12 : (e.getKey().equals("TABLE_NOT_AVAILABLE") ? 10 : 1))));
            throw SAPUtil.createExceptionBuilder(e).errorCode(errorCode).bapiName(functionName).tableName(tableName).build();
        }
        ArrayList<ISAPTableField> fieldList = new ArrayList<ISAPTableField>(1024);
        HashMap<String, Integer> lengthIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> offsetIndex = new HashMap<String, Integer>();
        JCoTable fields = this.getFieldsTable(function);
        for (int i = 0; i < fields.getNumRows(); ++i) {
            fields.setRow(i);
            String fieldName = fields.getString("FIELDNAME");
            String fieldText = fields.getString("FIELDTEXT");
            String fieldType = fields.getString("TYPE");
            SAPTableField field = new SAPTableField();
            field.setBusinessName(fieldText);
            field.setName(fieldName);
            field.setType(this.getFieldType(fieldType));
            fieldList.add(field);
            int length = Integer.parseInt(fields.getString("LENGTH"));
            int offset = Integer.parseInt(fields.getString("OFFSET"));
            lengthIndex.put(fieldName, length);
            offsetIndex.put(fieldName, offset);
        }
        SAPTableData tableData = new SAPTableData(this.getDataTable(function));
        tableData.setFieldList(fieldList);
        tableData.setLengthIndex(lengthIndex);
        tableData.setOffsetIndex(offsetIndex);
        return tableData;
    }

    protected JCoTable getDataTable(JCoFunction function) {
        if (this.useCustomFunction) {
            return function.getExportParameterList().getTable("ET_DATA");
        }
        return function.getTableParameterList().getTable("DATA");
    }

    protected JCoTable getFieldsTable(JCoFunction function) {
        if (this.useCustomFunction) {
            return function.getExportParameterList().getTable("ET_FIELDS");
        }
        return function.getTableParameterList().getTable("FIELDS");
    }

    protected void setFields(JCoFunction function, List<String> fieldNames) {
        if (fieldNames == null || fieldNames.isEmpty()) {
            return;
        }
        JCoTable fields = this.useCustomFunction ? function.getImportParameterList().getTable("IT_FIELDS") : function.getTableParameterList().getTable("FIELDS");
        for (String fieldName : fieldNames) {
            this.addField(fields, fieldName);
        }
    }

    protected void setMaxRows(JCoFunction function, Integer maxRows) {
        if (maxRows == null || maxRows <= 0) {
            return;
        }
        if (this.useCustomFunction) {
            function.getImportParameterList().setValue("IV_ROWCOUNT", maxRows.intValue());
        } else {
            function.getImportParameterList().setValue("ROWCOUNT", maxRows.intValue());
        }
    }

    protected void setQueryTable(JCoFunction function, String tableName) {
        if (this.useCustomFunction) {
            function.getImportParameterList().setValue("IV_QUERY_TABLE", tableName);
        } else {
            function.getImportParameterList().setValue("QUERY_TABLE", tableName);
        }
    }

    protected void setSkipCount(JCoFunction function, Integer skipCount) {
        if (skipCount == null || skipCount <= 0) {
            return;
        }
        if (this.useCustomFunction) {
            function.getImportParameterList().setValue("IV_ROWSKIPS", skipCount.intValue());
        } else {
            function.getImportParameterList().setValue("ROWSKIPS", skipCount.intValue());
        }
    }

    protected void setWhereClause(JCoFunction function, String condition) {
        if (this.useCustomFunction) {
            function.getImportParameterList().setValue("IV_WHERE_CLAUSE", condition);
        } else {
            JCoTable options = function.getTableParameterList().getTable("OPTIONS");
            if (condition != null) {
                List<String> parts = this.splitConditionIntoParts(condition);
                for (String part : parts) {
                    options.appendRow();
                    options.setValue(0, part);
                }
            }
        }
    }

    protected List<String> splitConditionIntoParts(String condition) {
        String loweredCondition = condition.toLowerCase();
        LinkedList<String> parts = new LinkedList<String>();
        int fromIndex = 0;
        while (fromIndex < condition.length()) {
            int and = loweredCondition.indexOf(TOKEN_AND, fromIndex);
            int or = loweredCondition.indexOf(TOKEN_OR, fromIndex);
            if (and == -1 && or == -1) {
                parts.add(condition.substring(fromIndex, condition.length()));
                break;
            }
            if (and != -1 && and < or) {
                parts.add(condition.substring(fromIndex, and));
                fromIndex = and + 1;
                continue;
            }
            if (or != -1 && or < and) {
                parts.add(condition.substring(fromIndex, or));
                fromIndex = or + 1;
                continue;
            }
            parts.add(condition.substring(fromIndex, and != -1 ? and : or));
            fromIndex = (and != -1 ? and : or) + 1;
        }
        return parts;
    }

    protected boolean useCustomFunction() {
        return this.useCustomFunction(this.connection.getProperties());
    }

    protected boolean useCustomFunction(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty("api.use_z_talend_read_table", "false"));
    }
}

