/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.util.Properties;
import org.talend.sap.impl.SAPConnectionDataProvider;
import org.talend.sap.impl.SAPServerDataProvider;

abstract class AbstractSAPFactory {
    private static final String API_PROPERTY_PREFIX = "api.";
    private static final String SERVER_PROPERTY_PREFIX = "jco.server.";
    private static final SAPConnectionDataProvider CONNECTION_DATA_PROVIDER = new SAPConnectionDataProvider();
    private static final SAPServerDataProvider SERVER_DATA_PROVIDER;

    AbstractSAPFactory() {
    }

    protected String addDestinationProperties(Properties properties) {
        return CONNECTION_DATA_PROVIDER.addDestinationProperties(properties);
    }

    protected String addServerProperties(Properties properties) {
        Properties clientProperties = new Properties();
        Properties serverProperties = new Properties();
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            String propertyKey = (String)key;
            if (this.isServerProperty(propertyKey)) {
                serverProperties.setProperty(propertyKey, properties.getProperty(propertyKey));
                continue;
            }
            clientProperties.setProperty(propertyKey, properties.getProperty(propertyKey));
        }
        this.checkHostProperties(clientProperties, serverProperties);
        String repositoryDestination = this.addDestinationProperties(clientProperties);
        serverProperties.setProperty("jco.server.repository_destination", repositoryDestination);
        return SERVER_DATA_PROVIDER.addServerProperties(serverProperties);
    }

    protected void checkHostProperties(Properties clientProperties, Properties serverProperties) {
        String asHost = "jco.client.ashost";
        String gwHost = "jco.server.gwhost";
        clientProperties.setProperty(asHost, clientProperties.getProperty(asHost, serverProperties.getProperty(gwHost)));
        serverProperties.setProperty(gwHost, serverProperties.getProperty(gwHost, clientProperties.getProperty(asHost)));
    }

    protected boolean isServerProperty(String propertyKey) {
        return propertyKey.startsWith(SERVER_PROPERTY_PREFIX) || propertyKey.startsWith(API_PROPERTY_PREFIX);
    }

    static {
        Environment.registerDestinationDataProvider((DestinationDataProvider)CONNECTION_DATA_PROVIDER);
        SERVER_DATA_PROVIDER = new SAPServerDataProvider();
        Environment.registerServerDataProvider((ServerDataProvider)SERVER_DATA_PROVIDER);
    }
}

