/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import org.talend.sap.ISAPServer;

public abstract class AbstractSAPServer
implements ISAPServer,
JCoServerStateChangedListener {
    protected final JCoServer server;

    public AbstractSAPServer(JCoServer server) {
        this.server = server;
        this.server.addServerStateChangedListener((JCoServerStateChangedListener)this);
    }

    protected boolean is(JCoServerState state) {
        return this.server.getState() == state;
    }

    public boolean isAlive() {
        return this.is(JCoServerState.ALIVE);
    }

    public boolean isStarted() {
        return this.is(JCoServerState.STARTED);
    }

    public boolean isStopped() {
        return this.is(JCoServerState.STOPPED);
    }

    public synchronized void start() {
        if (this.isStopped()) {
            this.server.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.isStarted() || this.isAlive()) {
            JCoServer jCoServer = this.server;
            synchronized (jCoServer) {
                try {
                    this.server.stop();
                    this.server.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.server.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStateChangeOccurred(JCoServer server, JCoServerState oldState, JCoServerState newState) {
        if (newState == JCoServerState.STOPPED) {
            JCoServer jCoServer = server;
            synchronized (jCoServer) {
                server.notify();
            }
        }
    }
}

