/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import java.util.LinkedList;
import java.util.Properties;
import org.talend.sap.ISAPConnection;
import org.talend.sap.ISAPConnectionMetadata;
import org.talend.sap.ISAPTransaction;
import org.talend.sap.impl.SAPConnectionMetadata;
import org.talend.sap.impl.SAPTransaction;
import org.talend.sap.impl.service.SAPBapiMetadataService;
import org.talend.sap.impl.service.SAPBapiService;
import org.talend.sap.impl.service.SAPIDocMetadataService;
import org.talend.sap.impl.service.SAPIDocService;
import org.talend.sap.impl.service.SAPTableDataService;
import org.talend.sap.impl.service.SAPTableMetadataService;
import org.talend.sap.service.ISAPBapiMetadataService;
import org.talend.sap.service.ISAPBapiService;
import org.talend.sap.service.ISAPIDocMetadataService;
import org.talend.sap.service.ISAPIDocService;
import org.talend.sap.service.ISAPTableDataService;
import org.talend.sap.service.ISAPTableMetadataService;

public class SAPConnection
implements ISAPConnection {
    protected final JCoDestination destination;
    protected final JCoRepository repository;
    protected ISAPConnectionMetadata metadata;
    protected ISAPBapiMetadataService bapiMetadataService;
    protected ISAPBapiService bapiService;
    protected ISAPIDocMetadataService idocMetadataService;
    protected ISAPIDocService idocService;
    protected ISAPTableDataService tableDataService;
    protected ISAPTableMetadataService tableMetadataService;
    private ThreadLocal<ISAPTransaction> transactions;

    public SAPConnection(JCoDestination destination) throws JCoException {
        this(destination, destination.getRepository());
    }

    public SAPConnection(JCoDestination destination, JCoRepository repository) {
        this.destination = destination;
        this.repository = repository;
        this.init();
    }

    protected void init() {
        this.metadata = new SAPConnectionMetadata(this.destination);
        this.transactions = new ThreadLocal();
        this.bapiMetadataService = new SAPBapiMetadataService(this);
        this.bapiService = new SAPBapiService(this);
        this.idocMetadataService = new SAPIDocMetadataService(this);
        this.idocService = new SAPIDocService(this);
        this.tableDataService = new SAPTableDataService(this);
        this.tableMetadataService = new SAPTableMetadataService(this);
    }

    public synchronized ISAPTransaction beginTransaction() {
        ISAPTransaction transaction = this.transactions.get();
        if (transaction == null || !transaction.isAlive()) {
            transaction = new SAPTransaction(this.destination, this.repository);
            this.transactions.set(transaction);
            return transaction;
        }
        return null;
    }

    public void close() {
    }

    public ISAPBapiMetadataService getBapiMetadataService() {
        return this.bapiMetadataService;
    }

    public ISAPBapiService getBapiService() {
        return this.bapiService;
    }

    public JCoDestination getDestination() {
        return this.destination;
    }

    public ISAPIDocMetadataService getIDocMetadataService() {
        return this.idocMetadataService;
    }

    public ISAPIDocService getIDocService() {
        return this.idocService;
    }

    public ISAPConnectionMetadata getMetadata() {
        return this.metadata;
    }

    public Properties getProperties() {
        return this.destination != null ? this.destination.getProperties() : new Properties();
    }

    public JCoRepository getRepository() {
        return this.repository;
    }

    public ISAPTableDataService getTableDataService() {
        return this.tableDataService;
    }

    public ISAPTableMetadataService getTableMetadataService() {
        return this.tableMetadataService;
    }

    public ISAPTransaction getTransaction() {
        ISAPTransaction transaction = this.transactions.get();
        return transaction != null ? (transaction.isAlive() ? transaction : null) : null;
    }

    public boolean isAlive() {
        try {
            this.destination.ping();
        }
        catch (JCoException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getSimpleName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" [\n");
        Properties props = this.destination.getProperties();
        LinkedList<String> propertyNames = new LinkedList<String>(props.stringPropertyNames());
        for (int i = 0; i < propertyNames.size(); ++i) {
            sb.append("  ");
            sb.append(i == 0 ? " " : ",");
            sb.append((String)propertyNames.get(i));
            sb.append("=");
            sb.append(props.getProperty((String)propertyNames.get(i)));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

