/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.JCoServerFactory;
import java.util.Properties;
import org.talend.sap.ISAPServerFactory;
import org.talend.sap.exception.SAPException;
import org.talend.sap.idoc.ISAPIDocReceiver;
import org.talend.sap.impl.AbstractSAPFactory;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.SAPIDocReceiver;
import org.talend.sap.impl.idoc.SAPIDocTransaction;

public class SAPServerFactory
extends AbstractSAPFactory
implements ISAPServerFactory {
    private static final ISAPServerFactory INSTANCE = new SAPServerFactory();

    public static ISAPServerFactory getInstance() {
        return INSTANCE;
    }

    protected SAPServerFactory() {
    }

    public ISAPIDocReceiver createIDocReceiver(Properties properties) throws SAPException {
        return this.createIDocReceiver(properties, true);
    }

    public ISAPIDocReceiver createIDocReceiver(Properties properties, boolean transactional) throws SAPException {
        if (properties == null) {
            throw new IllegalArgumentException("The given server properties are null.");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("The given server properties are empty.");
        }
        String serverName = this.addServerProperties(properties);
        SAPIDocReceiver receiver = null;
        try {
            receiver = transactional ? new SAPIDocTransaction(JCoServerFactory.getServer((String)serverName)) : new SAPIDocReceiver(JCoServerFactory.getServer((String)serverName));
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(0).build();
        }
        return receiver;
    }
}

