/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.talend.sap.idoc.ISAPIDoc;
import org.talend.sap.idoc.ISAPIDocIterator;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.SAPIDocIterator;
import org.talend.sap.impl.idoc.SAPIDocSupport;
import org.talend.sap.impl.idoc.record.SAPIDocControlRecord;

public class SAPIDoc
implements ISAPIDoc {
    private final char[] array;

    public SAPIDoc(char[] array) {
        this.array = array;
    }

    public char[] array() {
        return this.array;
    }

    protected String get(SAPIDocControlRecord controlRecordField) {
        String value = new String(this.array, controlRecordField.offset(), controlRecordField.length()).trim();
        return value.isEmpty() ? null : value;
    }

    public String getClient() {
        return this.get(SAPIDocControlRecord.CLIENT);
    }

    public Date getCreationDateTime() {
        DateFormat dateFormat = SAPUtil.createDateFormat();
        DateFormat timeFormat = SAPUtil.createTimeFormat();
        Calendar creationDate = Calendar.getInstance();
        Calendar creationTime = Calendar.getInstance();
        String creationDateValue = this.get(SAPIDocControlRecord.CREATION_DATE);
        String creationTimeValue = this.get(SAPIDocControlRecord.CREATION_TIME);
        try {
            creationDate.setTime(dateFormat.parse(creationDateValue));
            creationTime.setTime(timeFormat.parse(creationTimeValue));
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("IDOC creation time '%s' could not be parsed.", creationDateValue + creationTimeValue), e);
        }
        creationTime.set(creationDate.get(1), creationDate.get(2), creationDate.get(5));
        return creationTime.getTime();
    }

    public String getExtension() {
        return this.get(SAPIDocControlRecord.EXTENSION);
    }

    public String getMessageType() {
        return this.get(SAPIDocControlRecord.MESSAGE_TYPE);
    }

    public String getNumber() {
        return this.get(SAPIDocControlRecord.DOCUMENT_NUMBER);
    }

    public String getReceiverPartnerNumber() {
        return this.get(SAPIDocControlRecord.RECEIVER_PARTNER_NUMBER);
    }

    public String getReceiverPartnerType() {
        return this.get(SAPIDocControlRecord.RECEIVER_PARTNER_TYPE);
    }

    public String getReceiverPort() {
        return this.get(SAPIDocControlRecord.RECEIVER_PORT);
    }

    public String getRelease() {
        return this.get(SAPIDocControlRecord.DOCUMENT_RELEASE);
    }

    public int getStatus() {
        return Integer.parseInt(this.get(SAPIDocControlRecord.STATUS));
    }

    public String getSenderPartnerNumber() {
        return this.get(SAPIDocControlRecord.SENDER_PARTNER_NUMBER);
    }

    public String getSenderPartnerType() {
        return this.get(SAPIDocControlRecord.RECEIVER_PARTNER_TYPE);
    }

    public String getSenderPort() {
        return this.get(SAPIDocControlRecord.SENDER_PORT);
    }

    protected SAPIDocSupport getSupport() {
        return (SAPIDocSupport)SAPIDocSupport.getInstance();
    }

    public String getType() {
        return this.get(SAPIDocControlRecord.TYPE);
    }

    public boolean hasTestFlag() {
        return SAPUtil.isTrue(this.get(SAPIDocControlRecord.TEST_FLAG));
    }

    public ISAPIDocIterator iterator() {
        return new SAPIDocIterator(this.array);
    }

    public void toFile(File file) throws IOException {
        this.getSupport().toFile((ISAPIDoc)this, file);
    }

    public void toFile(File file, String charsetName) throws IOException {
        this.getSupport().toFile((ISAPIDoc)this, file, charsetName);
    }

    public void toFile(String filePath) throws IOException {
        this.getSupport().toFile((ISAPIDoc)this, filePath);
    }

    public void toFile(String filePath, String charsetName) throws IOException {
        this.getSupport().toFile((ISAPIDoc)this, filePath, charsetName);
    }

    public String toString() {
        return new String(this.array);
    }
}

