/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.talend.sap.exception.SAPException;
import org.talend.sap.idoc.ISAPIDocData;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.SAPIDocIterator;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;

public class SAPIDocData
implements ISAPIDocData {
    private final SAPIDocIterator iterator;

    public SAPIDocData(SAPIDocIterator iterator) {
        this.iterator = iterator;
    }

    public BigDecimal getBigDecimal(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(SAPUtil.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public BigInteger getBigInteger(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return new BigInteger(SAPUtil.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public boolean getBoolean(int offset) {
        String value = this.getString(offset, 1);
        if (value == null) {
            return false;
        }
        return SAPUtil.isTrue(value);
    }

    public Byte getByte(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public Date getDate(int offset) throws SAPException {
        String value = this.getString(offset, 8);
        if (value == null || offset > 992) {
            return null;
        }
        if (value.length() != 8) {
            throw this.newParseException(value, offset, "The value must contain exactly 8 characters!");
        }
        try {
            return SAPUtil.createDateFormat().parse(value);
        }
        catch (ParseException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public Integer getInteger(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(SAPUtil.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public Long getLong(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(SAPUtil.toNumericString(value));
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public Short getShort(int offset, int length) throws SAPException {
        String value = this.getString(offset, length);
        if (value == null) {
            return null;
        }
        try {
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    public String getString(int offset, int length) {
        int dataLength = this.iterator.end() - this.iterator.start() - SAPIDocDataRecord.MIN_RECORD_SIZE;
        if (offset >= dataLength || length == 0) {
            return null;
        }
        length = offset + length > dataLength ? dataLength - offset : length;
        offset = this.iterator.start() + SAPIDocDataRecord.MIN_RECORD_SIZE + offset;
        String value = new String(this.iterator.array(), offset, length).trim();
        return value.isEmpty() ? null : value;
    }

    public Date getTime(int offset) throws SAPException {
        String value = this.getString(offset, 6);
        if (value == null || offset > 994) {
            return null;
        }
        if (value.length() != 6) {
            throw this.newParseException(value, offset, "The value must contain exactly 6 characters!");
        }
        try {
            return SAPUtil.createTimeFormat().parse(value);
        }
        catch (ParseException e) {
            throw this.newParseException(value, offset, e.getMessage());
        }
    }

    protected SAPException newParseException(String value, int offset, String message) {
        return SAPException.newBuilder().errorCode(-1).errorGroup(-1).errorMessage(String.format("Value '%s' at offset '%d' could not be parsed: %s", value, offset, message)).build();
    }

    public String toString() {
        return new String(this.iterator.array(), this.iterator.start() + SAPIDocDataRecord.MIN_RECORD_SIZE, this.iterator.end() - this.iterator.start() - SAPIDocDataRecord.MIN_RECORD_SIZE);
    }
}

