/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import org.talend.sap.idoc.ISAPIDocData;
import org.talend.sap.idoc.ISAPIDocIterator;
import org.talend.sap.impl.idoc.SAPIDocData;
import org.talend.sap.impl.idoc.record.SAPIDocControlRecord;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;

public class SAPIDocIterator
implements ISAPIDocIterator {
    private final ISAPIDocData data;
    private final char[] array;
    private final int size;
    private int start;
    private int end;

    public SAPIDocIterator(char[] array) {
        this.array = array;
        this.size = array.length;
        this.data = new SAPIDocData(this);
        this.firstRecord();
    }

    protected char[] array() {
        return this.array;
    }

    protected int end() {
        return this.end;
    }

    protected void findEndPosition() {
        this.end = this.start;
        while (this.end < this.size - 1 && this.array[this.end] != '\n') {
            ++this.end;
        }
    }

    protected void findStartPosition() {
        this.start = this.end;
        while (this.start > 0 && this.array[this.start - 1] != '\n') {
            --this.start;
        }
    }

    public void firstRecord() {
        this.start = SAPIDocControlRecord.FIXED_RECORD_SIZE + 1;
        this.findEndPosition();
    }

    protected String get(SAPIDocDataRecord dataRecordField) {
        String value = new String(this.array, this.start + dataRecordField.offset(), dataRecordField.length()).trim();
        return value.isEmpty() ? null : value;
    }

    public String getClient() {
        return this.get(SAPIDocDataRecord.CLIENT);
    }

    public ISAPIDocData getApplicationData() {
        return this.data;
    }

    public String getDocumentNumber() {
        return this.get(SAPIDocDataRecord.DOCUMENT_NUMBER);
    }

    public int getHierarchyLevel() {
        return Integer.parseInt(this.get(SAPIDocDataRecord.HIERARCHY_LEVEL));
    }

    public int getParentSegmentNumber() {
        return Integer.parseInt(this.get(SAPIDocDataRecord.PARENT_SEGMENT_NUMBER));
    }

    public String getSegmentName() {
        return this.get(SAPIDocDataRecord.SEGMENT_NAME);
    }

    public int getSegmentNumber() {
        return Integer.parseInt(this.get(SAPIDocDataRecord.SEGMENT_NUMBER));
    }

    public boolean isLastRecord() {
        return this.end == this.size - 1;
    }

    public boolean isFirstRecord() {
        return this.start == SAPIDocControlRecord.FIXED_RECORD_SIZE + 1;
    }

    public void lastRecord() {
        this.end = this.size - 1;
        this.findStartPosition();
    }

    public boolean nextRecord() {
        if (this.isLastRecord()) {
            return false;
        }
        this.start = this.end + 1;
        this.findEndPosition();
        return true;
    }

    public int position() {
        return this.start;
    }

    public boolean previousRecord() {
        if (this.isFirstRecord()) {
            return false;
        }
        this.end = this.start - 1;
        this.findStartPosition();
        return true;
    }

    protected int start() {
        return this.start;
    }

    public String toString() {
        return new String(this.array, this.start, this.end - this.start);
    }
}

