/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.talend.sap.idoc.ISAPIDoc;
import org.talend.sap.idoc.ISAPIDocPackage;
import org.talend.sap.impl.idoc.SAPIDocTransactionState;

public class SAPIDocPackage
implements ISAPIDocPackage {
    private final List<ISAPIDoc> idocList;
    private final String tid;
    private SAPIDocTransactionState state;
    private String rollbackMessage;

    public SAPIDocPackage(String tid, int idocCount) {
        this.tid = tid;
        this.idocList = new ArrayList<ISAPIDoc>(idocCount);
        this.state = null;
    }

    protected void add(ISAPIDoc idoc) {
        this.idocList.add(idoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.state == null) {
            throw new UnsupportedOperationException("Only the transactional receiver supports commit()");
        }
        SAPIDocPackage sAPIDocPackage = this;
        synchronized (sAPIDocPackage) {
            this.setState(SAPIDocTransactionState.COMMIT);
            this.notify();
        }
    }

    public ISAPIDoc get(int index) {
        return this.idocList.get(index);
    }

    protected String getRollbackMessage() {
        return this.rollbackMessage;
    }

    protected SAPIDocTransactionState getState() {
        return this.state;
    }

    public String getTID() {
        return this.tid;
    }

    public Iterator<ISAPIDoc> iterator() {
        return this.idocList.iterator();
    }

    public void rollback() {
        this.rollback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(String message) {
        if (this.state == null) {
            throw new UnsupportedOperationException("Only the transactional receiver supports rollback()");
        }
        SAPIDocPackage sAPIDocPackage = this;
        synchronized (sAPIDocPackage) {
            this.rollbackMessage = message;
            this.setState(SAPIDocTransactionState.ROLLBACK);
            this.notify();
        }
    }

    protected synchronized void setState(SAPIDocTransactionState state) {
        if (this.state == SAPIDocTransactionState.COMMIT) {
            throw new IllegalStateException("The transaction has already been committed.");
        }
        if (this.state == SAPIDocTransactionState.ROLLBACK) {
            throw new IllegalStateException("The transaction has already been rolled back.");
        }
        if (this.state == SAPIDocTransactionState.ABORT) {
            throw new IllegalStateException("The transaction has already been aborted.");
        }
        this.state = state;
    }

    public int size() {
        return this.idocList.size();
    }
}

