/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.nio.CharBuffer;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.talend.sap.idoc.ISAPIDoc;
import org.talend.sap.idoc.ISAPIDocPackage;
import org.talend.sap.idoc.ISAPIDocReceiver;
import org.talend.sap.idoc.ISAPIDocSupport;
import org.talend.sap.impl.AbstractSAPServer;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.SAPIDocPackage;
import org.talend.sap.impl.idoc.SAPIDocSupport;
import org.talend.sap.impl.idoc.SAPIDocUtil;
import org.talend.sap.impl.idoc.record.SAPIDocControlRecord;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;
import org.talend.sap.impl.idoc.record.SAPIDocRecordField;

public class SAPIDocReceiver
extends AbstractSAPServer
implements ISAPIDocReceiver,
JCoServerFunctionHandler,
JCoServerTIDHandler {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return SAPUtil.createDateFormat();
        }
    };
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return SAPUtil.createTimeFormat();
        }
    };
    private final BlockingQueue<ISAPIDocPackage> idocQueue = new LinkedBlockingQueue<ISAPIDocPackage>();
    private final ISAPIDocSupport idocSupport = SAPIDocSupport.getInstance();

    public SAPIDocReceiver(JCoServer server) {
        super(server);
        this.init();
    }

    protected void init() {
        DefaultServerHandlerFactory.FunctionHandlerFactory functionHandlerFactory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
        functionHandlerFactory.registerHandler("IDOC_INBOUND_ASYNCHRONOUS", (Object)this);
        this.server.setCallHandlerFactory((JCoServerCallHandlerFactory)functionHandlerFactory);
        this.server.setTIDHandler((JCoServerTIDHandler)this);
    }

    public boolean isTransactional() {
        return false;
    }

    public synchronized ISAPIDocPackage receive(long timeout) {
        ISAPIDocPackage idocPackage = null;
        try {
            switch (this.server.getState()) {
                case ALIVE: 
                case STARTED: {
                    idocPackage = this.take(timeout);
                    break;
                }
                case DEAD: {
                    return null;
                }
                case STOPPED: {
                    this.start();
                    idocPackage = this.take(timeout);
                    break;
                }
                case STOPPING: {
                    TimeUnit.SECONDS.sleep(1L);
                    return this.receive(100L);
                }
            }
        }
        catch (InterruptedException ex) {
            return null;
        }
        if (idocPackage != null && !SAPIDocUtil.isPoison(idocPackage)) {
            return idocPackage;
        }
        super.stop();
        return null;
    }

    private ISAPIDocPackage take(long timeout) throws InterruptedException {
        return timeout < 0L ? this.idocQueue.take() : this.idocQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.enqueue(SAPIDocUtil.getPoisonPackage());
    }

    public void handleRequest(JCoServerContext serverContext, JCoFunction function) {
        switch (this.getIDocCount(function)) {
            case 0: {
                return;
            }
            case 1: {
                this.handleSingle(serverContext, function);
                break;
            }
            default: {
                this.handleMultiple(serverContext, function);
            }
        }
    }

    protected void enqueue(String tid, CharBuffer ... buffers) {
        SAPIDocPackage idocPackage = new SAPIDocPackage(tid, buffers.length);
        for (CharBuffer buffer : buffers) {
            idocPackage.add(this.getIDoc(buffer));
        }
        this.enqueue(idocPackage);
    }

    protected void enqueue(SAPIDocPackage idocPackage) {
        this.idocQueue.add(idocPackage);
    }

    protected ISAPIDoc getIDoc(CharBuffer buffer) {
        int length = buffer.position();
        char[] array = new char[length];
        buffer.rewind();
        buffer.get(array, 0, length);
        return this.idocSupport.from(array);
    }

    protected int getIDocCount(JCoFunction function) {
        return function.getTableParameterList().getTable("IDOC_CONTROL_REC_40").getNumRows();
    }

    protected void handleMultiple(JCoServerContext serverContext, JCoFunction function) {
        int i;
        String documentNumber;
        int i2;
        JCoTable controlRecordTable = function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
        JCoTable dataRecordTable = function.getTableParameterList().getTable("IDOC_DATA_REC_40");
        int[] capacities = new int[controlRecordTable.getNumRows()];
        for (int i3 = 0; i3 < capacities.length; ++i3) {
            capacities[i3] = SAPIDocControlRecord.FIXED_RECORD_SIZE + 1;
        }
        HashMap<String, Integer> documentIndex = new HashMap<String, Integer>(capacities.length, 1.0f);
        for (i2 = 0; i2 < controlRecordTable.getNumRows(); ++i2) {
            controlRecordTable.setRow(i2);
            documentNumber = controlRecordTable.getString(SAPIDocControlRecord.DOCUMENT_NUMBER.fieldName());
            documentIndex.put(documentNumber, i2);
        }
        for (i2 = 0; i2 < dataRecordTable.getNumRows(); ++i2) {
            int index;
            dataRecordTable.setRow(i2);
            documentNumber = dataRecordTable.getString(SAPIDocDataRecord.DOCUMENT_NUMBER.fieldName());
            int n = index = ((Integer)documentIndex.get(documentNumber)).intValue();
            capacities[n] = capacities[n] + (SAPIDocDataRecord.MAX_RECORD_SIZE + 1);
        }
        CharBuffer[] buffers = new CharBuffer[capacities.length];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = CharBuffer.allocate(capacities[i]);
        }
        for (i = 0; i < controlRecordTable.getNumRows(); ++i) {
            controlRecordTable.setRow(i);
            this.putControlRecord(buffers[i], controlRecordTable);
        }
        for (i = 0; i < dataRecordTable.getNumRows(); ++i) {
            dataRecordTable.setRow(i);
            String documentNumber2 = dataRecordTable.getString(SAPIDocDataRecord.DOCUMENT_NUMBER.fieldName());
            int index = (Integer)documentIndex.get(documentNumber2);
            this.putDataRecord(buffers[index], dataRecordTable);
        }
        this.enqueue(serverContext.getTID(), buffers);
        controlRecordTable.clear();
        dataRecordTable.clear();
        capacities = null;
        documentIndex.clear();
        buffers = null;
    }

    protected void handleSingle(JCoServerContext serverContext, JCoFunction function) {
        JCoTable controlRecordTable = function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
        JCoTable dataRecordTable = function.getTableParameterList().getTable("IDOC_DATA_REC_40");
        int capacity = SAPIDocControlRecord.FIXED_RECORD_SIZE + 1;
        for (int i = 0; i < dataRecordTable.getNumRows(); ++i) {
            dataRecordTable.setRow(i);
            capacity += SAPIDocDataRecord.MAX_RECORD_SIZE + 1;
        }
        CharBuffer buffer = CharBuffer.allocate(capacity);
        controlRecordTable.firstRow();
        this.putControlRecord(buffer, controlRecordTable);
        for (int i = 0; i < dataRecordTable.getNumRows(); ++i) {
            dataRecordTable.setRow(i);
            this.putDataRecord(buffer, dataRecordTable);
        }
        this.enqueue(serverContext.getTID(), buffer);
        controlRecordTable.clear();
        dataRecordTable.clear();
        buffer = null;
    }

    protected void put(CharBuffer buffer, JCoTable table, SAPIDocRecordField recordField) {
        buffer.put(table.getCharArray(recordField.fieldName()));
    }

    protected void put(CharBuffer buffer, JCoTable table, SAPIDocRecordField recordField, DateFormat dateFormat) {
        buffer.put(dateFormat.format(table.getDate(recordField.fieldName())));
    }

    protected void putControlRecord(CharBuffer buffer, JCoTable controlRecordTable) {
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.TABLE_STRUCTURE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.CLIENT);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.DOCUMENT_NUMBER);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.DOCUMENT_RELEASE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.STATUS);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.DIRECTION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.OUTPUT_MODE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.EXPRESS);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.TEST_FLAG);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.TYPE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.EXTENSION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.MESSAGE_TYPE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.MESSAGE_CODE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.MESSAGE_FUNCTION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.STANDARD_FLAG);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.STANDARD_VERSION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.STANDARD_MESSAGE_TYPE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_PORT);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_PARTNER_TYPE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_PARTNER_FUNCTION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_PARTNER_NUMBER);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_ADDRESS);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SENDER_ADDRESS_LOGICAL);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_PORT);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_PARTNER_TYPE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_PARTNER_FUNCTION);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_PARTNER_NUMBER);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_ADDRESS);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.RECEIVER_ADDRESS_LOGICAL);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.CREATION_DATE, DATE_FORMAT.get());
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.CREATION_TIME, TIME_FORMAT.get());
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.EDI_INTERCHANGE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.EDI_MESSAGE_GROUP);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.EDI_MESSAGE);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.ARCHIVE_KEY);
        this.put(buffer, controlRecordTable, SAPIDocControlRecord.SERIAL);
        buffer.put('\n');
    }

    protected void putDataRecord(CharBuffer buffer, JCoTable dataRecordTable) {
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.SEGMENT_NAME);
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.CLIENT);
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.DOCUMENT_NUMBER);
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.SEGMENT_NUMBER);
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.PARENT_SEGMENT_NUMBER);
        this.put(buffer, dataRecordTable, SAPIDocDataRecord.HIERARCHY_LEVEL);
        String sdata = dataRecordTable.getString(SAPIDocDataRecord.APPLICATION_DATA.fieldName());
        buffer.put(sdata);
        buffer.put('\n');
    }

    public boolean checkTID(JCoServerContext serverContext, String tid) {
        return true;
    }

    public void commit(JCoServerContext serverContext, String tid) {
    }

    public void confirmTID(JCoServerContext serverContext, String tid) {
    }

    public void rollback(JCoServerContext serverContext, String tid) {
    }
}

