/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.talend.sap.idoc.ISAPIDoc;
import org.talend.sap.idoc.ISAPIDocSupport;
import org.talend.sap.impl.idoc.SAPIDoc;
import org.talend.sap.impl.idoc.record.SAPIDocControlRecord;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;

public class SAPIDocSupport
implements ISAPIDocSupport {
    private static final ISAPIDocSupport INSTANCE = new SAPIDocSupport();

    public static ISAPIDocSupport getInstance() {
        return INSTANCE;
    }

    protected SAPIDocSupport() {
    }

    public ISAPIDoc from(char[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The given character array is null.");
        }
        if (array.length < SAPIDocControlRecord.FIXED_RECORD_SIZE + 1 + SAPIDocDataRecord.MIN_RECORD_SIZE) {
            throw new RuntimeException(String.format("Malformed IDOC: An IDOC must contain at least one complete data record (second line) with %d characters.", SAPIDocControlRecord.FIXED_RECORD_SIZE));
        }
        if (array[SAPIDocControlRecord.FIXED_RECORD_SIZE] != '\n') {
            throw new RuntimeException(String.format("Malformed IDOC: The control record (first line) must contain exactly %d characters.", SAPIDocControlRecord.FIXED_RECORD_SIZE));
        }
        return new SAPIDoc(array);
    }

    public ISAPIDoc fromFile(File file) throws IOException {
        return this.fromFile(file, Charset.defaultCharset().displayName());
    }

    public ISAPIDoc fromFile(File file, String charsetName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The given file is null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The given file '%s' does not exist.", file.getAbsolutePath()));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("The given file '%s' is not a file.", file.getAbsolutePath()));
        }
        return this.fromStream(new FileInputStream(file), charsetName);
    }

    public ISAPIDoc fromFile(String filePath) throws IOException {
        return this.fromFile(filePath, Charset.defaultCharset().displayName());
    }

    public ISAPIDoc fromFile(String filePath, String charsetName) throws IOException {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("The given file path is null or empty.");
        }
        return this.fromFile(new File(filePath), charsetName);
    }

    public ISAPIDoc fromStream(InputStream stream) throws IOException {
        return this.fromStream(stream, Charset.defaultCharset().displayName());
    }

    public ISAPIDoc fromStream(InputStream stream, String charsetName) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("The given stream is null.");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("The given charset name is null.");
        }
        StringBuilder builder = new StringBuilder(8192);
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, charsetName));
        String line = r.readLine();
        if (line == null || line.length() != SAPIDocControlRecord.FIXED_RECORD_SIZE) {
            throw new RuntimeException(String.format("Malformed IDOC: The control record (first line) must contain exactly %d characters.", SAPIDocControlRecord.FIXED_RECORD_SIZE));
        }
        builder.append(line);
        while ((line = r.readLine()) != null) {
            if (line.length() + 1 > builder.capacity() - builder.length()) {
                builder.ensureCapacity(builder.capacity() * 2);
            }
            builder.append('\n');
            builder.append(line);
        }
        r.close();
        char[] array = new char[builder.length()];
        builder.getChars(0, builder.length(), array, 0);
        return this.from(array);
    }

    protected void toFile(ISAPIDoc idoc, File file) throws IOException {
        this.toFile(idoc, file, Charset.defaultCharset().displayName());
    }

    protected void toFile(ISAPIDoc idoc, File file, String charsetName) throws IOException {
        if (idoc == null) {
            throw new IllegalArgumentException("The given IDOC is null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given file is null.");
        }
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException(String.format("The given file '%s' is not a file.", file.getAbsolutePath()));
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("The given charset name is null.");
        }
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName);
        output.write(idoc.array(), 0, idoc.array().length);
        output.close();
    }

    protected void toFile(ISAPIDoc idoc, String filePath) throws IOException {
        this.toFile(idoc, filePath, Charset.defaultCharset().displayName());
    }

    protected void toFile(ISAPIDoc idoc, String filePath, String charsetName) throws IOException {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("The given file path is null or empty.");
        }
        this.toFile(idoc, new File(filePath), charsetName);
    }
}

