/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.idoc;

import com.sap.conn.jco.server.JCoServer;
import org.talend.sap.impl.idoc.SAPIDocPackage;
import org.talend.sap.impl.idoc.SAPIDocReceiver;
import org.talend.sap.impl.idoc.SAPIDocTransactionState;
import org.talend.sap.impl.idoc.SAPIDocUtil;

public class SAPIDocTransaction
extends SAPIDocReceiver {
    private final long abortTimeout = this.getAbortTimeout();

    public SAPIDocTransaction(JCoServer server) {
        super(server);
    }

    protected void abort(String message) {
        throw new RuntimeException(String.format("Transaction aborted: %s", message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enqueue(SAPIDocPackage idocPackage) {
        idocPackage.setState(SAPIDocTransactionState.IN_PROGRESS);
        super.enqueue(idocPackage);
        if (SAPIDocUtil.isPoison(idocPackage)) {
            return;
        }
        SAPIDocPackage sAPIDocPackage = idocPackage;
        synchronized (sAPIDocPackage) {
            try {
                idocPackage.wait(this.abortTimeout);
                switch (idocPackage.getState()) {
                    case IN_PROGRESS: {
                        idocPackage.setState(SAPIDocTransactionState.ABORT);
                        this.abort(String.format("Abort timeout of %d milliseconds expired.", this.abortTimeout));
                        break;
                    }
                    case ROLLBACK: {
                        this.rollback(idocPackage.getRollbackMessage());
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                idocPackage.setState(SAPIDocTransactionState.ABORT);
                this.abort(String.format("InterruptedException occured: %s", e.getMessage()));
            }
        }
    }

    protected long getAbortTimeout() {
        String propertyKey = "api.idoc_transaction_wait_timout";
        String propertyValue = this.server.getProperty(propertyKey);
        if (propertyValue != null) {
            try {
                return Long.parseLong(propertyValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Value '%s' of property '%s' cannot be parsed to long.", propertyValue, propertyKey));
            }
        }
        return 60000L;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    protected void rollback(String message) {
        if (message != null) {
            throw new RuntimeException(String.format("Transaction rolled back: %s", message));
        }
        throw new RuntimeException("Transaction rolled back.");
    }
}

