/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.model.bapi.parameter;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import java.util.ArrayList;
import java.util.List;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.model.bapi.parameter.SAPParameterMetadata;
import org.talend.sap.model.bapi.parameter.ISAPParameterMetadata;
import org.talend.sap.model.bapi.parameter.ISAPParameterMetadataList;

public class SAPParameterMetadataList
implements ISAPParameterMetadataList {
    private final JCoRepository repository;
    private final JCoMetaData metaData;
    private final List<Integer> indexes;

    public SAPParameterMetadataList(JCoRepository repository, JCoListMetaData metaDataList, boolean isInput) {
        this.repository = repository;
        this.metaData = metaDataList;
        this.indexes = new ArrayList<Integer>(metaDataList.getFieldCount());
        if (isInput) {
            for (int i = 0; i < this.metaData.getFieldCount(); ++i) {
                if (!metaDataList.isImport(i) && !metaDataList.isChanging(i) && (!metaDataList.isTable(i) || metaDataList.isExport(i))) continue;
                this.indexes.add(i);
            }
        } else {
            for (int i = 0; i < metaDataList.getFieldCount(); ++i) {
                if (!metaDataList.isExport(i) && !metaDataList.isChanging(i) && (!metaDataList.isTable(i) || metaDataList.isImport(i))) continue;
                this.indexes.add(i);
            }
        }
    }

    public SAPParameterMetadataList(JCoRepository repository, JCoMetaData metaData) {
        this.repository = repository;
        this.metaData = metaData;
        this.indexes = new ArrayList<Integer>(metaData.getFieldCount());
        for (int i = 0; i < metaData.getFieldCount(); ++i) {
            this.indexes.add(i);
        }
    }

    public int getParameterCount() {
        return this.indexes.size();
    }

    public ISAPParameterMetadata getParameterMetadata(int parameterIndex) {
        SAPParameterMetadata metadata = new SAPParameterMetadata();
        metadata.setDescription(this.metaData.getDescription(this.indexes.get(parameterIndex).intValue()));
        metadata.setName(this.metaData.getName(this.indexes.get(parameterIndex).intValue()));
        metadata.setType(SAPUtil.getParameterType(this.metaData.getType(this.indexes.get(parameterIndex).intValue())));
        if (this.isSingle(parameterIndex)) {
            metadata.setLength(this.metaData.getLength(this.indexes.get(parameterIndex).intValue()));
        }
        if (this.metaData instanceof JCoListMetaData) {
            JCoListMetaData metaDataList = (JCoListMetaData)this.metaData;
            metadata.setDefaultValue(metaDataList.getDefault(this.indexes.get(parameterIndex).intValue()));
            metadata.setOptional(metaDataList.isOptional(this.indexes.get(parameterIndex).intValue()));
        }
        return metadata;
    }

    public ISAPParameterMetadataList getParameterMetadataList(int parameterIndex) throws SAPException {
        JCoRecordMetaData recordMetaData = null;
        try {
            recordMetaData = this.repository.getRecordMetaData(this.metaData.getRecordTypeName(this.indexes.get(parameterIndex).intValue()));
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(1).build();
        }
        return new SAPParameterMetadataList(this.repository, (JCoMetaData)recordMetaData);
    }

    public boolean isSingle(int parameterIndex) {
        return !this.isStructure(parameterIndex) && !this.isTable(parameterIndex);
    }

    public boolean isStructure(int parameterIndex) {
        return this.metaData.getType(this.indexes.get(parameterIndex).intValue()) == 17;
    }

    public boolean isTable(int parameterIndex) {
        return this.metaData.getType(this.indexes.get(parameterIndex).intValue()) == 99;
    }
}

