/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.model.idoc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.talend.sap.impl.model.idoc.SAPIDocTypeMetadata;
import org.talend.sap.model.idoc.ISAPIDocTypeMetadata;

public class SAPIDocTypeMetadataUtil {
    public static ISAPIDocTypeMetadata load(InputStream inputStream) {
        SAPIDocTypeMetadata metadata = null;
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            metadata = (SAPIDocTypeMetadata)new Gson().fromJson((Reader)reader, SAPIDocTypeMetadata.class);
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        metadata.setUpParentChildRelation();
        return metadata;
    }

    public static ISAPIDocTypeMetadata load(String filePath) {
        try {
            return SAPIDocTypeMetadataUtil.load(new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String save(ISAPIDocTypeMetadata metadata, String directoryPath) {
        String filePath = directoryPath + "/" + metadata.getName() + ".json";
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)((SAPIDocTypeMetadata)metadata), (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return filePath;
    }
}

