/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.model.idoc;

import java.util.ArrayList;
import java.util.List;
import org.talend.sap.impl.model.idoc.SAPSegmentField;
import org.talend.sap.model.idoc.ISAPSegment;
import org.talend.sap.model.idoc.ISAPSegmentField;

public class SAPSegment
implements ISAPSegment {
    private transient SAPSegment parent;
    private transient List<SAPSegment> children;
    private int parentNumber = -1;
    private List<SAPSegmentField> fields;
    private String definitionName;
    private String description;
    private int hierarchyLevel;
    private int length;
    private long maximumOccurence;
    private long minimumOccurence;
    private int number;
    private boolean qualified;
    private boolean required;
    private String typeName;

    public void addChild(SAPSegment segment) {
        this.ensureChildren();
        this.children.add(segment);
    }

    public void addField(SAPSegmentField field) {
        this.ensureFields();
        this.fields.add(field);
    }

    protected void ensureChildren() {
        if (this.children == null) {
            this.children = new ArrayList<SAPSegment>();
        }
    }

    protected void ensureFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<SAPSegmentField>();
        }
    }

    public ISAPSegment getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public String getDescription() {
        return this.description;
    }

    public ISAPSegmentField getField(int index) {
        return this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields != null ? this.fields.size() : 0;
    }

    public int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    public int getLength() {
        return this.length;
    }

    public long getMaximumOccurrence() {
        return this.maximumOccurence;
    }

    public long getMinimumOccurrence() {
        return this.minimumOccurence;
    }

    public int getNumber() {
        return this.number;
    }

    public ISAPSegment getParent() {
        return this.parent;
    }

    protected int getParentNumber() {
        return this.parentNumber;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHierarchyLevel(int hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMaximumOccurence(long maximumOccurence) {
        this.maximumOccurence = maximumOccurence;
    }

    public void setMinimumOccurence(long minimumOccurence) {
        this.minimumOccurence = minimumOccurence;
    }

    public void setNumber(int number) {
        this.number = number - 1;
    }

    public void setParent(SAPSegment parent) {
        this.parent = parent;
        this.parentNumber = parent.getNumber();
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setQualified(boolean qualified) {
        this.qualified = qualified;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

