/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMNamespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.model.bapi.SAPBapi;
import org.talend.sap.impl.model.bapi.SAPBapiGroup;
import org.talend.sap.impl.model.bapi.SAPBapiMetadata;
import org.talend.sap.impl.model.bapi.parameter.SAPParameterListType;
import org.talend.sap.impl.service.AbstractSAPService;
import org.talend.sap.model.bapi.ISAPBapi;
import org.talend.sap.model.bapi.ISAPBapiGroup;
import org.talend.sap.model.bapi.ISAPBapiMetadata;
import org.talend.sap.service.ISAPBapiMetadataService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAPBapiMetadataService
extends AbstractSAPService
implements ISAPBapiMetadataService {
    private final boolean includeComments = this.includeComments();

    public SAPBapiMetadataService(SAPConnection connection) {
        super(connection);
    }

    public List<ISAPBapi> getBapisByGroup(ISAPBapiGroup group) throws SAPException {
        if (group == null) {
            throw new IllegalArgumentException("The given BAPI group is null.");
        }
        return this.getBapisByGroupName(group.getName());
    }

    public List<ISAPBapi> getBapisByGroupName(String groupName) throws SAPException {
        if (groupName == null) {
            throw new IllegalArgumentException("The given BAPI group name is null.");
        }
        if (groupName.isEmpty()) {
            throw new IllegalArgumentException("The given BAPI group name is empty.");
        }
        return this.searchBapis(null, groupName);
    }

    public ISAPBapiMetadata getBapiMetadata(ISAPBapi bapi) throws SAPException {
        if (bapi == null) {
            throw new IllegalArgumentException("The given BAPI is null.");
        }
        JCoListMetaData listMetaData = null;
        try {
            listMetaData = this.repository.getFunctionInterface(bapi.getName());
        }
        catch (JCoException e) {
            int errorCode = e.getGroup() == 123 ? 20 : 1;
            throw SAPUtil.createExceptionBuilder(e).errorCode(errorCode).bapiName(bapi.getName()).build();
        }
        SAPBapiMetadata metadata = new SAPBapiMetadata(this.repository, listMetaData);
        metadata.setDescription(bapi.getDescription());
        metadata.setGroupName(bapi.getGroupName());
        metadata.setName(bapi.getName());
        metadata.setInputXsd(this.buildInputXsd(listMetaData));
        metadata.setOutputXsd(this.buildOutputXsd(listMetaData));
        return metadata;
    }

    public ISAPBapiMetadata getBapiMetadataByName(String bapiName) throws SAPException {
        if (bapiName == null) {
            throw new IllegalArgumentException("The given BAPI name is null.");
        }
        if (bapiName.isEmpty()) {
            throw new IllegalArgumentException("The given BAPI name is empty.");
        }
        return this.getBapiMetadata(new SAPBapi(bapiName));
    }

    public List<ISAPBapi> searchBapis(String conditionOnName, String conditionOnGroupName) throws SAPException {
        boolean noFunctionFound;
        JCoFunction function;
        block4: {
            function = this.getFunction("RFC_FUNCTION_SEARCH");
            conditionOnName = this.isAll(conditionOnName) ? "*" : conditionOnName;
            conditionOnGroupName = this.isAll(conditionOnGroupName) ? "*" : conditionOnGroupName;
            JCoParameterList parameter = function.getImportParameterList();
            parameter.setValue("FUNCNAME", conditionOnName);
            parameter.setValue("GROUPNAME", conditionOnGroupName);
            parameter.setValue("LANGUAGE", this.destination.getLanguage().toUpperCase());
            noFunctionFound = false;
            try {
                function.execute(this.destination);
            }
            catch (JCoException e) {
                noFunctionFound = "NO_FUNCTION_FOUND".equals(e.getKey());
                if (noFunctionFound) break block4;
                throw SAPUtil.createExceptionBuilder(e).errorCode(1).bapiName("RFC_FUNCTION_SEARCH").build();
            }
        }
        LinkedList<ISAPBapi> bapis = new LinkedList<ISAPBapi>();
        if (!noFunctionFound) {
            JCoTable functions = function.getTableParameterList().getTable("FUNCTIONS");
            for (int i = 0; i < functions.getNumRows(); ++i) {
                functions.setRow(i);
                SAPBapi bapi = new SAPBapi();
                bapi.setDescription(functions.getString("STEXT").trim());
                bapi.setGroupName(functions.getString("GROUPNAME").trim());
                bapi.setName(functions.getString("FUNCNAME").trim());
                bapis.add(bapi);
            }
        }
        return bapis;
    }

    public List<ISAPBapiGroup> searchBapiGroups(String conditionOnGroupName) throws SAPException {
        boolean noGroupFound;
        JCoFunction function;
        block4: {
            function = this.getFunction("RFC_GROUP_SEARCH");
            conditionOnGroupName = this.isAll(conditionOnGroupName) ? "*" : conditionOnGroupName;
            JCoParameterList parameter = function.getImportParameterList();
            parameter.setValue("GROUPNAME", conditionOnGroupName);
            parameter.setValue("LANGUAGE", this.destination.getLanguage().toUpperCase());
            noGroupFound = false;
            try {
                function.execute(this.destination);
            }
            catch (JCoException e) {
                noGroupFound = "NO_GROUP_FOUND".equals(e.getKey());
                if (noGroupFound) break block4;
                throw SAPUtil.createExceptionBuilder(e).errorCode(1).bapiName("RFC_GROUP_SEARCH").build();
            }
        }
        LinkedList<ISAPBapiGroup> groups = new LinkedList<ISAPBapiGroup>();
        if (!noGroupFound) {
            JCoTable result = function.getTableParameterList().getTable("GROUPS");
            for (int i = 0; i < result.getNumRows(); ++i) {
                result.setRow(i);
                SAPBapiGroup group = new SAPBapiGroup();
                group.setDescription(result.getString("STEXT").trim());
                group.setName(result.getString("GROUPNAME").trim());
                groups.add(group);
            }
        }
        return groups;
    }

    protected String buildInputXsd(JCoListMetaData listMetaData) throws SAPException {
        DOMDocument document = new DOMDocument();
        DOMElement schemaElement = this.addSchemaElement(document);
        DOMElement rootElement = this.addAllElement(schemaElement, listMetaData.getName());
        for (int i = 0; i < listMetaData.getFieldCount(); ++i) {
            DOMElement parentElement = null;
            if (listMetaData.isChanging(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.CHANGING.tagName());
            } else if (listMetaData.isImport(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.IMPORT.tagName());
            } else if (listMetaData.isTable(i) && !listMetaData.isExport(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.TABLES.tagName());
            }
            if (parentElement == null) continue;
            this.addParameter(parentElement, (JCoMetaData)listMetaData, i);
        }
        return this.formatXsd(document);
    }

    protected String buildOutputXsd(JCoListMetaData listMetaData) throws SAPException {
        DOMDocument document = new DOMDocument();
        DOMElement schemaElement = this.addSchemaElement(document);
        DOMElement rootElement = this.addAllElement(schemaElement, listMetaData.getName());
        for (int i = 0; i < listMetaData.getFieldCount(); ++i) {
            DOMElement parentElement = null;
            if (listMetaData.isChanging(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.CHANGING.tagName());
            } else if (listMetaData.isExport(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.EXPORT.tagName());
            } else if (listMetaData.isTable(i) && !listMetaData.isImport(i)) {
                parentElement = this.addAllElement(rootElement, SAPParameterListType.TABLES.tagName());
            }
            if (parentElement == null) continue;
            this.addParameter(parentElement, (JCoMetaData)listMetaData, i);
        }
        return this.formatXsd(document);
    }

    protected DOMElement addAllElement(DOMElement parentElement, String name) {
        return this.addAllElement(parentElement, name, null);
    }

    protected DOMElement addAllElement(DOMElement parentElement, String name, DOMComment comment) {
        DOMNamespace xs = (DOMNamespace)parentElement.getNamespace();
        DOMElement element = this.getChildByNameAttr(parentElement, name = SAPUtil.replaceNamespace(name));
        if (element == null) {
            element = new DOMElement("element", (Namespace)xs);
            element.setAttribute("name", name);
            DOMElement complexType = new DOMElement("complexType", (Namespace)xs);
            DOMElement all = new DOMElement("all", (Namespace)xs);
            if (comment != null) {
                parentElement.add((Comment)comment);
            }
            parentElement.add((Element)element);
            element.add((Element)complexType);
            complexType.add((Element)all);
        }
        return (DOMElement)element.getElementsByTagName("all").item(0);
    }

    protected void addParameter(DOMElement parentElement, JCoMetaData metaData, int index) throws SAPException {
        if (metaData.getType(index) == 99) {
            this.addParameterTable(parentElement, metaData, index);
        } else if (metaData.getType(index) == 17) {
            this.addParameterStructure(parentElement, metaData, index);
        } else {
            this.addParameterSingle(parentElement, metaData, index);
        }
    }

    protected void addParameterSingle(DOMElement parentElement, JCoMetaData metadata, int index) {
        String name = SAPUtil.replaceNamespace(metadata.getName(index));
        String baseType = SAPUtil.getXsdType(metadata.getType(index));
        if (baseType == null) {
            throw new RuntimeException(String.format("Type '%s' of parameter with name '%s' is not mapped!", metadata.getType(index), metadata.getName(index)));
        }
        DOMNamespace xs = (DOMNamespace)parentElement.getNamespace();
        DOMElement element = new DOMElement("element", (Namespace)xs);
        element.setAttribute("name", name);
        element.setAttribute("minOccurs", "0");
        DOMElement simpleType = new DOMElement("simpleType", (Namespace)xs);
        DOMElement restriction = new DOMElement("restriction", (Namespace)xs);
        restriction.setAttribute("base", baseType);
        parentElement.add((Element)element);
        element.add((Element)simpleType);
        simpleType.add((Element)restriction);
        int length = metadata.getLength(index);
        if (baseType.equals("xs:string") && length > 0) {
            DOMElement maxLength = new DOMElement("maxLength", (Namespace)xs);
            maxLength.setAttribute("value", String.valueOf(length));
            restriction.add((Element)maxLength);
        }
    }

    protected void addParameterStructure(DOMElement parent, JCoMetaData metadata, int index) throws SAPException {
        DOMComment comment = null;
        if (this.includeComments) {
            comment = new DOMComment(String.format(" Type '%s' ", metadata.getRecordTypeName(index)));
        }
        DOMElement allElement = this.addAllElement(parent, metadata.getName(index), comment);
        JCoRecordMetaData recordMetaData = this.getRecordMetaData(metadata.getRecordTypeName(index));
        for (int i = 0; i < recordMetaData.getFieldCount(); ++i) {
            this.addParameter(allElement, (JCoMetaData)recordMetaData, i);
        }
    }

    protected void addParameterTable(DOMElement parent, JCoMetaData metadata, int index) throws SAPException {
        DOMComment comment = null;
        if (this.includeComments) {
            comment = new DOMComment(String.format(" Type '%s' ", metadata.getRecordTypeName(index)));
        }
        DOMElement allElement = this.addTableItemAll(parent, metadata.getName(index), comment);
        JCoRecordMetaData recordMetaData = this.getRecordMetaData(metadata.getRecordTypeName(index));
        for (int i = 0; i < recordMetaData.getFieldCount(); ++i) {
            this.addParameter(allElement, (JCoMetaData)recordMetaData, i);
        }
    }

    protected DOMElement addSchemaElement(DOMDocument document) {
        DOMElement schemaElement = new DOMElement("schema", (Namespace)new DOMNamespace("xs", "http://www.w3.org/2001/XMLSchema"));
        document.add((Element)schemaElement);
        return schemaElement;
    }

    protected DOMElement addTableItemAll(DOMElement parentElement, String name, DOMComment comment) {
        DOMNamespace xs = (DOMNamespace)parentElement.getNamespace();
        DOMElement element = this.getChildByNameAttr(parentElement, name = SAPUtil.replaceNamespace(name));
        if (element == null) {
            element = new DOMElement("element", (Namespace)xs);
            element.setAttribute("name", name);
            DOMElement complexType = new DOMElement("complexType", (Namespace)xs);
            DOMElement sequence = new DOMElement("sequence", (Namespace)xs);
            sequence.setAttribute("minOccurs", "0");
            sequence.setAttribute("maxOccurs", "unbounded");
            if (comment != null) {
                parentElement.add((Comment)comment);
            }
            parentElement.add((Element)element);
            element.add((Element)complexType);
            complexType.add((Element)sequence);
            this.addAllElement(sequence, "item");
        }
        return (DOMElement)element.getElementsByTagName("all").item(0);
    }

    protected String formatXsd(DOMDocument xsd) {
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)sw, OutputFormat.createPrettyPrint());
        try {
            writer.write((Document)xsd);
        }
        catch (IOException e) {
            throw new RuntimeException("XSD could not be written to string.", e);
        }
        return sw.toString();
    }

    protected DOMElement getChildByNameAttr(DOMElement parentElement, String value) {
        NodeList childNodes = parentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            DOMElement element;
            Node node = childNodes.item(i);
            if (!(node instanceof DOMElement) || !value.equals((element = (DOMElement)node).getAttribute("name"))) continue;
            return element;
        }
        return null;
    }

    protected JCoRecordMetaData getRecordMetaData(String recordTypeName) throws SAPException {
        try {
            return this.repository.getRecordMetaData(recordTypeName);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(1).build();
        }
    }

    protected boolean includeComments() {
        return this.includeComments(this.connection.getProperties());
    }

    protected boolean includeComments(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty("api.include_xsd_comments", "false"));
    }
}

