/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.talend.sap.contract.IDOCTYPES_LIST_WITH_MESSAGES;
import org.talend.sap.contract.IDOCTYPE_READ_COMPLETE;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;
import org.talend.sap.impl.model.idoc.SAPIDocType;
import org.talend.sap.impl.model.idoc.SAPIDocTypeMetadata;
import org.talend.sap.impl.model.idoc.SAPMessageType;
import org.talend.sap.impl.model.idoc.SAPSegment;
import org.talend.sap.impl.model.idoc.SAPSegmentField;
import org.talend.sap.impl.model.idoc.SAPSegmentFieldValue;
import org.talend.sap.impl.model.idoc.query.SAPIDocQuery;
import org.talend.sap.impl.model.idoc.query.SAPIDocTypeQuery;
import org.talend.sap.impl.model.idoc.query.SAPMessageTypeQuery;
import org.talend.sap.impl.service.AbstractSAPService;
import org.talend.sap.model.idoc.ISAPIDocType;
import org.talend.sap.model.idoc.ISAPIDocTypeMetadata;
import org.talend.sap.model.idoc.ISAPMessageType;
import org.talend.sap.model.idoc.query.ISAPIDocTypeQuery;
import org.talend.sap.model.idoc.query.ISAPMessageTypeQuery;
import org.talend.sap.service.ISAPIDocMetadataService;

public class SAPIDocMetadataService
extends AbstractSAPService
implements ISAPIDocMetadataService {
    public SAPIDocMetadataService(SAPConnection sapConnection) {
        super(sapConnection);
    }

    public ISAPIDocTypeQuery createIDocTypeQuery() {
        return new SAPIDocTypeQuery(this);
    }

    public ISAPMessageTypeQuery createMessageTypeQuery() {
        return new SAPMessageTypeQuery(this);
    }

    public ISAPIDocTypeMetadata getIDocMetadata(ISAPIDocType idocType) throws SAPException {
        if (idocType == null) {
            throw new IllegalArgumentException("The given IDOC type is null.");
        }
        return this.getIDocMetadataByName(idocType.getName(), idocType.getExtensionName());
    }

    public ISAPIDocTypeMetadata getIDocMetadataByName(String idocTypeName) throws SAPException {
        return this.getIDocMetadataByName(idocTypeName, null);
    }

    public ISAPIDocTypeMetadata getIDocMetadataByName(String idocTypeName, String extensionName) throws SAPException {
        if (idocTypeName == null || idocTypeName.isEmpty()) {
            throw new IllegalArgumentException("The given IDOC type name is null or empty.");
        }
        JCoFunction function = this.getFunction("IDOCTYPE_READ_COMPLETE");
        function.getImportParameterList().setValue("PI_IDOCTYP", idocTypeName);
        if (extensionName != null && !extensionName.isEmpty()) {
            function.getImportParameterList().setValue("PI_CIMTYP", extensionName);
        }
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            boolean isUnknown = "OBJECT_UNKNOWN".equals(e.getKey());
            boolean isRelationInvalid = "RELATION_NOT_FOUND".equals(e.getKey());
            int errorCode = isUnknown ? 30 : (isRelationInvalid ? 31 : 1);
            throw SAPUtil.createExceptionBuilder(e).errorCode(errorCode).bapiName(function.getName()).build();
        }
        SAPIDocTypeMetadata metadata = this.extractHeader(function);
        Map<String, SAPSegment> segmentMap = this.extractSegments(function);
        this.extractFields(function, segmentMap);
        metadata.setSegments(new ArrayList<SAPSegment>(segmentMap.values()));
        return metadata;
    }

    public List<ISAPIDocType> list(SAPIDocTypeQuery query) throws SAPException {
        JCoFunction function = this.getFunction("IDOCTYPES_LIST_WITH_MESSAGES");
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(1).bapiName(function.getName()).build();
        }
        return new ArrayList<ISAPIDocType>(this.getIDocTypeMap(query, function).values());
    }

    public List<ISAPMessageType> list(SAPMessageTypeQuery query) throws SAPException {
        JCoFunction function = this.getFunction("IDOCTYPES_LIST_WITH_MESSAGES");
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(1).bapiName(function.getName()).build();
        }
        Map<String, ISAPIDocType> idocTypeMap = this.getIDocTypeMap(new SAPIDocTypeQuery(this), function);
        TreeMap<String, SAPMessageType> messageTypeMap = new TreeMap<String, SAPMessageType>();
        StringBuilder sb = new StringBuilder(61);
        JCoTable messageTypeTable = function.getTableParameterList().getTable("PT_MESSAGES");
        for (int i = 0; i < messageTypeTable.getNumRows(); ++i) {
            String key;
            messageTypeTable.setRow(i);
            String messageTypeName = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getTypeName(messageTypeTable);
            String description = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getDescription(messageTypeTable);
            SAPMessageType messageType = (SAPMessageType)messageTypeMap.get(messageTypeName);
            if (messageType == null) {
                if (!this.matches(messageTypeName, query.getConditionOnName()) || !this.matches(description, query.getConditionOnDescription())) continue;
                messageType = new SAPMessageType();
                messageType.setDescription(description);
                messageType.setName(messageTypeName);
                messageTypeMap.put(messageType.getName(), messageType);
            }
            String idocTypeName = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getIDocTypeName(messageTypeTable);
            String extensionName = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getIDocExtensionName(messageTypeTable);
            if (extensionName != null) {
                sb.setLength(0);
                sb.append(idocTypeName);
                sb.append("|");
                sb.append(extensionName);
                key = sb.toString();
            } else {
                key = idocTypeName;
            }
            ISAPIDocType idocType = idocTypeMap.get(key);
            if (idocType == null || !this.releaseMatches(idocType.getRelease(), query)) continue;
            messageType.addIDocType(idocType);
        }
        ArrayList<ISAPMessageType> list = new ArrayList<ISAPMessageType>(messageTypeMap.size());
        for (ISAPMessageType messageType : messageTypeMap.values()) {
            if (messageType.getIDocTypes().isEmpty()) continue;
            list.add(messageType);
        }
        return list;
    }

    protected void extractFields(JCoFunction function, Map<String, SAPSegment> segmentMap) {
        JCoTable fieldTable = function.getTableParameterList().getTable("PT_FIELDS");
        JCoTable fieldValueTable = function.getTableParameterList().getTable("PT_FVALUES");
        int fieldValueTableIndex = fieldValueTable.isEmpty() ? -1 : 0;
        for (int i = 0; i < fieldTable.getNumRows(); ++i) {
            fieldTable.setRow(i);
            SAPSegmentField field = new SAPSegmentField();
            field.setDataType(IDOCTYPE_READ_COMPLETE.FIELDS.getDataType(fieldTable));
            field.setDescription(IDOCTYPE_READ_COMPLETE.FIELDS.getDescription(fieldTable));
            field.setLength(IDOCTYPE_READ_COMPLETE.FIELDS.getLength(fieldTable));
            field.setName(IDOCTYPE_READ_COMPLETE.FIELDS.getName(fieldTable));
            int offset = IDOCTYPE_READ_COMPLETE.FIELDS.getOffset(fieldTable) - SAPIDocDataRecord.MIN_RECORD_SIZE - 1;
            field.setOffset(offset);
            field.setType(SAPUtil.getIDocFieldType(field.getDataType()));
            String segmentTypeName = IDOCTYPE_READ_COMPLETE.FIELDS.getSegmentTypeName(fieldTable);
            if (fieldValueTableIndex >= 0) {
                fieldValueTableIndex = this.extractFieldValues(fieldValueTable, fieldValueTableIndex, segmentTypeName, field);
            }
            segmentMap.get(segmentTypeName).addField(field);
        }
    }

    protected int extractFieldValues(JCoTable fieldValueTable, int fieldValueTableIndex, String currentSegmentTypeName, SAPSegmentField currentField) {
        while (fieldValueTableIndex < fieldValueTable.getNumRows()) {
            fieldValueTable.setRow(fieldValueTableIndex);
            String segmentTypeName = IDOCTYPE_READ_COMPLETE.VALUES.getSegmentTypeName(fieldValueTable);
            String fieldName = IDOCTYPE_READ_COMPLETE.VALUES.getFieldName(fieldValueTable);
            if (!currentSegmentTypeName.equals(segmentTypeName) || !currentField.getName().equals(fieldName)) break;
            SAPSegmentFieldValue value = new SAPSegmentFieldValue();
            value.setDescription(IDOCTYPE_READ_COMPLETE.VALUES.getDescription(fieldValueTable));
            value.setValue(IDOCTYPE_READ_COMPLETE.VALUES.getValue(fieldValueTable));
            currentField.addValue(value);
            ++fieldValueTableIndex;
        }
        return fieldValueTableIndex;
    }

    protected SAPIDocTypeMetadata extractHeader(JCoFunction function) {
        JCoStructure structure = function.getExportParameterList().getStructure("PE_HEADER");
        SAPIDocTypeMetadata metadata = new SAPIDocTypeMetadata();
        metadata.setDescription(IDOCTYPE_READ_COMPLETE.HEADER.getDescription(structure));
        metadata.setExtensionName(IDOCTYPE_READ_COMPLETE.HEADER.getExtensionName(structure));
        metadata.setName(IDOCTYPE_READ_COMPLETE.HEADER.getName(structure));
        metadata.setRelease(IDOCTYPE_READ_COMPLETE.HEADER.getRelease(structure));
        return metadata;
    }

    protected Map<String, SAPSegment> extractSegments(JCoFunction function) {
        LinkedHashMap<String, SAPSegment> segmentMap = new LinkedHashMap<String, SAPSegment>();
        JCoTable table = function.getTableParameterList().getTable("PT_SEGMENTS");
        for (int i = 0; i < table.getNumRows(); ++i) {
            SAPSegment parent;
            table.setRow(i);
            SAPSegment segment = new SAPSegment();
            segment.setDefinitionName(IDOCTYPE_READ_COMPLETE.SEGMENTS.getDefinitionName(table));
            segment.setDescription(IDOCTYPE_READ_COMPLETE.SEGMENTS.getDescription(table));
            segment.setHierarchyLevel(IDOCTYPE_READ_COMPLETE.SEGMENTS.getHierarchyLevel(table));
            segment.setLength(IDOCTYPE_READ_COMPLETE.SEGMENTS.getLength(table));
            segment.setNumber(IDOCTYPE_READ_COMPLETE.SEGMENTS.getNumber(table));
            segment.setQualified(this.isTrue(IDOCTYPE_READ_COMPLETE.SEGMENTS.getQualifierFlag(table)));
            segment.setTypeName(IDOCTYPE_READ_COMPLETE.SEGMENTS.getTypeName(table));
            if (this.isTrue(IDOCTYPE_READ_COMPLETE.SEGMENTS.getParentFlag(table))) {
                segment.setMaximumOccurence(IDOCTYPE_READ_COMPLETE.SEGMENTS.getMaxGroupOccurrence(table));
                segment.setMinimumOccurence(IDOCTYPE_READ_COMPLETE.SEGMENTS.getMinGroupOccurrence(table));
                segment.setRequired(this.isTrue(IDOCTYPE_READ_COMPLETE.SEGMENTS.getGroupRequiredFlag(table)));
            } else {
                segment.setMaximumOccurence(IDOCTYPE_READ_COMPLETE.SEGMENTS.getMaxOccurrence(table));
                segment.setMinimumOccurence(IDOCTYPE_READ_COMPLETE.SEGMENTS.getMinOccurrence(table));
                segment.setRequired(this.isTrue(IDOCTYPE_READ_COMPLETE.SEGMENTS.getRequiredFlag(table)));
            }
            if (!segment.isRequired()) {
                segment.setMinimumOccurence(0L);
            }
            if ((parent = (SAPSegment)segmentMap.get(IDOCTYPE_READ_COMPLETE.SEGMENTS.getParentSegmentName(table))) != null) {
                segment.setParent(parent);
                parent.addChild(segment);
            }
            segmentMap.put(segment.getTypeName(), segment);
        }
        return segmentMap;
    }

    protected Map<String, ISAPIDocType> getIDocTypeMap(SAPIDocTypeQuery query, JCoFunction function) throws SAPException {
        HashMap<String, String> descriptionMap = new HashMap<String, String>(256);
        HashMap<String, String> releaseMap = new HashMap<String, String>(256);
        JCoTable idocTypeTable = function.getTableParameterList().getTable("PT_IDOCTYPES");
        for (int i = 0; i < idocTypeTable.getNumRows(); ++i) {
            String release;
            String description;
            idocTypeTable.setRow(i);
            String idocTypeName = IDOCTYPES_LIST_WITH_MESSAGES.IDOCTYPES.getTypeName(idocTypeTable);
            if (!this.matches(idocTypeName, query.getConditionOnName()) || !this.matches(description = IDOCTYPES_LIST_WITH_MESSAGES.IDOCTYPES.getDescription(idocTypeTable), query.getConditionOnDescription()) || !this.releaseMatches(release = IDOCTYPES_LIST_WITH_MESSAGES.IDOCTYPES.getRelease(idocTypeTable), query)) continue;
            descriptionMap.put(idocTypeName, description);
            releaseMap.put(idocTypeName, release);
        }
        TreeMap<String, ISAPIDocType> idocTypeMap = new TreeMap<String, ISAPIDocType>();
        StringBuilder sb = new StringBuilder(61);
        JCoTable messageTypeTable = function.getTableParameterList().getTable("PT_MESSAGES");
        for (int i = 0; i < messageTypeTable.getNumRows(); ++i) {
            String key;
            messageTypeTable.setRow(i);
            String idocTypeName = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getIDocTypeName(messageTypeTable);
            if (!descriptionMap.containsKey(idocTypeName)) continue;
            String extensionName = IDOCTYPES_LIST_WITH_MESSAGES.MESSAGETYPES.getIDocExtensionName(messageTypeTable);
            if (extensionName != null) {
                sb.setLength(0);
                sb.append(idocTypeName);
                sb.append("|");
                sb.append(extensionName);
                key = sb.toString();
            } else {
                key = idocTypeName;
            }
            if (idocTypeMap.containsKey(key) || !this.matches(extensionName, query.getConditionOnExtension())) continue;
            SAPIDocType idocType = new SAPIDocType();
            idocType.setDescription((String)descriptionMap.get(idocTypeName));
            idocType.setExtensionName(extensionName);
            idocType.setName(idocTypeName);
            idocType.setRelease((String)releaseMap.get(idocTypeName));
            idocTypeMap.put(key, idocType);
        }
        return idocTypeMap;
    }

    protected boolean matches(String value, String condition) {
        if (this.isAll(condition)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (condition.startsWith("*") && condition.endsWith("*")) {
            return value.contains(condition.substring(1, condition.length() - 1));
        }
        if (condition.endsWith("*")) {
            return value.startsWith(condition.substring(0, condition.length() - 1));
        }
        if (condition.startsWith("*")) {
            return value.endsWith(condition.substring(1));
        }
        return value.equals(condition);
    }

    protected boolean releaseMatches(String release, SAPIDocQuery<?> query) {
        String releaseCondition = query.getRelease();
        if (this.isAll(releaseCondition)) {
            return true;
        }
        switch (query.getReleaseComparator()) {
            case BEFORE: {
                return releaseCondition.compareToIgnoreCase(release) > 0;
            }
            case EQUAL_TO: {
                return releaseCondition.compareToIgnoreCase(release) == 0;
            }
            case AFTER: {
                return releaseCondition.compareToIgnoreCase(release) < 0;
            }
        }
        return false;
    }
}

