/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.talend.sap.exception.SAPException;
import org.talend.sap.idoc.ISAPIDoc;
import org.talend.sap.idoc.ISAPIDocIterator;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.idoc.SAPIDocUtil;
import org.talend.sap.impl.idoc.record.SAPIDocControlRecord;
import org.talend.sap.impl.idoc.record.SAPIDocDataRecord;
import org.talend.sap.impl.service.AbstractSAPService;
import org.talend.sap.service.ISAPIDocService;

public class SAPIDocService
extends AbstractSAPService
implements ISAPIDocService {
    public SAPIDocService(SAPConnection connection) {
        super(connection);
    }

    public void send(ISAPIDoc idoc) throws SAPException {
        if (idoc == null) {
            throw new IllegalArgumentException("The given IDOC is null.");
        }
        this.send(Arrays.asList(idoc));
    }

    public void send(List<ISAPIDoc> idocList) throws SAPException {
        if (idocList == null || idocList.isEmpty()) {
            throw new IllegalArgumentException("The given IDOC list is null or empty.");
        }
        JCoFunction function = this.getFunction("IDOC_INBOUND_ASYNCHRONOUS");
        JCoTable controlRecordTable = function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
        JCoTable dataRecordTable = function.getTableParameterList().getTable("IDOC_DATA_REC_40");
        for (ISAPIDoc idoc : idocList) {
            this.append(controlRecordTable, dataRecordTable, idoc);
        }
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).bapiName(function.getName()).build();
        }
    }

    protected void append(JCoTable controlRecordTable, JCoTable dataRecordTable, ISAPIDoc idoc) {
        this.appendControlRecord(controlRecordTable, idoc);
        this.appendDataRecords(dataRecordTable, idoc);
    }

    protected void appendControlRecord(JCoTable controlRecordTable, ISAPIDoc idoc) {
        controlRecordTable.appendRow();
        char[] array = idoc.array();
        this.set(controlRecordTable, array, SAPIDocControlRecord.TABLE_STRUCTURE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.CLIENT);
        this.set(controlRecordTable, array, SAPIDocControlRecord.DOCUMENT_NUMBER);
        this.set(controlRecordTable, array, SAPIDocControlRecord.DOCUMENT_RELEASE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.STATUS);
        this.set(controlRecordTable, array, SAPIDocControlRecord.DIRECTION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.OUTPUT_MODE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.EXPRESS);
        this.set(controlRecordTable, array, SAPIDocControlRecord.TEST_FLAG);
        this.set(controlRecordTable, array, SAPIDocControlRecord.TYPE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.EXTENSION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.MESSAGE_TYPE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.MESSAGE_CODE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.MESSAGE_FUNCTION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.STANDARD_FLAG);
        this.set(controlRecordTable, array, SAPIDocControlRecord.STANDARD_VERSION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.STANDARD_MESSAGE_TYPE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_PORT);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_PARTNER_TYPE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_PARTNER_FUNCTION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_PARTNER_NUMBER);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_ADDRESS);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SENDER_ADDRESS_LOGICAL);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_PORT);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_PARTNER_TYPE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_PARTNER_FUNCTION);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_PARTNER_NUMBER);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_ADDRESS);
        this.set(controlRecordTable, array, SAPIDocControlRecord.RECEIVER_ADDRESS_LOGICAL);
        Date creationTime = idoc.getCreationDateTime();
        this.setDate(controlRecordTable, SAPIDocControlRecord.CREATION_DATE, creationTime);
        this.setDate(controlRecordTable, SAPIDocControlRecord.CREATION_TIME, creationTime);
        this.set(controlRecordTable, array, SAPIDocControlRecord.EDI_INTERCHANGE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.EDI_MESSAGE_GROUP);
        this.set(controlRecordTable, array, SAPIDocControlRecord.EDI_MESSAGE);
        this.set(controlRecordTable, array, SAPIDocControlRecord.ARCHIVE_KEY);
        this.set(controlRecordTable, array, SAPIDocControlRecord.SERIAL);
    }

    protected void appendDataRecords(JCoTable dataRecordTable, ISAPIDoc idoc) {
        char[] array = idoc.array();
        ISAPIDocIterator iterator = idoc.iterator();
        do {
            dataRecordTable.appendRow();
            int position = iterator.position();
            this.set(dataRecordTable, array, SAPIDocDataRecord.SEGMENT_NAME, position);
            this.set(dataRecordTable, array, SAPIDocDataRecord.CLIENT, position);
            this.set(dataRecordTable, array, SAPIDocDataRecord.DOCUMENT_NUMBER, position);
            this.set(dataRecordTable, array, SAPIDocDataRecord.SEGMENT_NUMBER, position);
            this.set(dataRecordTable, array, SAPIDocDataRecord.PARENT_SEGMENT_NUMBER, position);
            this.set(dataRecordTable, array, SAPIDocDataRecord.HIERARCHY_LEVEL, position);
            char[] sdata = SAPIDocUtil.copyAndPad(new char[SAPIDocDataRecord.APPLICATION_DATA.length()], iterator.getApplicationData().toString());
            dataRecordTable.setValue(SAPIDocDataRecord.APPLICATION_DATA.fieldName(), sdata);
        } while (iterator.nextRecord());
    }

    protected void set(JCoTable table, char[] array, SAPIDocControlRecord recordField) {
        table.setValue(recordField.fieldName(), array, recordField.offset(), recordField.length());
    }

    protected void set(JCoTable table, char[] array, SAPIDocDataRecord recordField, int position) {
        table.setValue(recordField.fieldName(), array, position + recordField.offset(), recordField.length());
    }

    protected void setDate(JCoTable table, SAPIDocControlRecord recordField, Date date) {
        table.setValue(recordField.fieldName(), (Object)date);
    }
}

