/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.impl.service;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.talend.sap.exception.SAPException;
import org.talend.sap.impl.SAPConnection;
import org.talend.sap.impl.SAPUtil;
import org.talend.sap.impl.model.table.SAPTable;
import org.talend.sap.impl.model.table.SAPTableFieldMetadata;
import org.talend.sap.impl.model.table.SAPTableMetadata;
import org.talend.sap.impl.model.table.SAPTableRelation;
import org.talend.sap.impl.service.AbstractSAPService;
import org.talend.sap.model.SAPType;
import org.talend.sap.model.table.ISAPTable;
import org.talend.sap.model.table.ISAPTableFieldMetadata;
import org.talend.sap.model.table.ISAPTableMetadata;
import org.talend.sap.model.table.ISAPTableRelation;
import org.talend.sap.service.ISAPTableMetadataService;

public class SAPTableMetadataService
extends AbstractSAPService
implements ISAPTableMetadataService {
    public SAPTableMetadataService(SAPConnection connection) {
        super(connection);
    }

    public List<ISAPTableRelation> getForeignKeyRelations(String tableName) throws SAPException {
        if (tableName == null) {
            throw new IllegalArgumentException("The given table name is null.");
        }
        JCoFunction function = this.getFunction("RFC_READ_TABLE");
        function.getImportParameterList().setValue("QUERY_TABLE", "DD08L");
        JCoTable fields = function.getTableParameterList().getTable("FIELDS");
        this.addField(fields, "TABNAME");
        this.addField(fields, "FIELDNAME");
        this.addField(fields, "CHECKFLAG");
        JCoTable options = function.getTableParameterList().getTable("OPTIONS");
        this.addWhereClause(options, "CHECKTABLE", tableName);
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode("NOT_AUTHORIZED".equals(e.getKey()) ? 2 : 1).bapiName("RFC_READ_TABLE").tableName("DD08L").build();
        }
        fields = function.getTableParameterList().getTable("FIELDS");
        Map<String, Integer> lengthIndex = this.getLengthIndex(fields);
        Map<String, Integer> offsetIndex = this.getOffsetIndex(fields);
        LinkedList<ISAPTableRelation> relations = new LinkedList<ISAPTableRelation>();
        JCoTable data = function.getTableParameterList().getTable("DATA");
        for (int i = 0; i < data.getNumRows(); ++i) {
            data.setRow(i);
            SAPTableRelation relation = new SAPTableRelation();
            relation.setChecked(this.isTrue(this.extractFieldData(data.getString(0), "CHECKFLAG", offsetIndex, lengthIndex)));
            relation.setFieldName(this.extractFieldData(data.getString(0), "FIELDNAME", offsetIndex, lengthIndex));
            relation.setTableName(this.extractFieldData(data.getString(0), "TABNAME", offsetIndex, lengthIndex));
            relations.add(relation);
        }
        return relations;
    }

    public ISAPTableMetadata getTableMetadata(ISAPTable table) throws SAPException {
        if (table == null) {
            throw new IllegalArgumentException("The given table is null.");
        }
        JCoFunction function = this.getFunction("DDIF_FIELDINFO_GET");
        function.getImportParameterList().setValue("TABNAME", table.getName());
        function.getImportParameterList().setValue("LANGU", this.destination.getLanguage().toUpperCase());
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw SAPUtil.createExceptionBuilder(e).errorCode(1).bapiName("DDIF_FIELDINFO_GET").build();
        }
        LinkedList<ISAPTableFieldMetadata> fieldMetadataList = new LinkedList<ISAPTableFieldMetadata>();
        JCoTable fields = function.getTableParameterList().getTable("DFIES_TAB");
        for (int i = 0; i < fields.getNumRows(); ++i) {
            fields.setRow(i);
            SAPTableFieldMetadata fieldMetadata = new SAPTableFieldMetadata();
            fieldMetadata.setBusinessDescription(fields.getString("FIELDTEXT").trim());
            fieldMetadata.setBusinessName(fields.getString("SCRTEXT_L").trim());
            fieldMetadata.setKey(this.isTrue(fields.getString("KEYFLAG")));
            fieldMetadata.setLength(fields.getInt("LENG"));
            fieldMetadata.setName(fields.getString("FIELDNAME").trim());
            SAPType type = SAPUtil.getFieldType(fields.getString("INTTYPE"), fieldMetadata.getLength());
            fieldMetadata.setType(type);
            String checkTableName = fields.getString("CHECKTABLE").trim();
            fieldMetadata.setCheckTableName(checkTableName.isEmpty() ? null : checkTableName);
            String referencedTableName = fields.getString("REFTABLE").trim();
            fieldMetadata.setReferencedTableName(referencedTableName.isEmpty() ? null : referencedTableName);
            String referencedFieldName = fields.getString("REFFIELD").trim();
            fieldMetadata.setReferencedFieldName(referencedFieldName.isEmpty() ? null : referencedFieldName);
            if (fieldMetadata.getType() == SAPType.BIG_DECIMAL) {
                fieldMetadata.setScale(fields.getInt("DECIMALS"));
            }
            fieldMetadataList.add(fieldMetadata);
        }
        SAPTableMetadata metadata = new SAPTableMetadata();
        metadata.setDescription(table.getDescription());
        metadata.setFields(fieldMetadataList);
        metadata.setName(table.getName());
        String tableType = function.getExportParameterList().getString("DDOBJTYPE").trim();
        metadata.setType(SAPUtil.getTableType(tableType));
        return metadata;
    }

    public ISAPTableMetadata getTableMetadataByName(String tableName) throws SAPException {
        if (tableName == null) {
            throw new IllegalArgumentException("The given table name is null.");
        }
        return this.getTableMetadata(new SAPTable(tableName));
    }

    public List<ISAPTable> searchTables(String conditionOnName, String conditionOnDescription) throws SAPException {
        JCoFunction function = this.getFunction("RFC_READ_TABLE");
        function.getImportParameterList().setValue("QUERY_TABLE", "DD02T");
        JCoTable fields = function.getTableParameterList().getTable("FIELDS");
        this.addField(fields, "TABNAME");
        this.addField(fields, "DDTEXT");
        JCoTable options = function.getTableParameterList().getTable("OPTIONS");
        this.addWhereLikeClause(options, "TABNAME", conditionOnName);
        this.addWhereLikeClause(options, "DDTEXT", conditionOnDescription);
        this.addWhereClause(options, "DDLANGUAGE", this.destination.getLanguage().toUpperCase());
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            boolean isConditionTooLong = SAPUtil.isConditionTooLong(e);
            boolean isNotAuthorized = "NOT_AUTHORIZED".equals(e.getKey());
            int errorCode = isNotAuthorized ? 2 : (isConditionTooLong ? 12 : 1);
            throw SAPUtil.createExceptionBuilder(e).errorMessage(isConditionTooLong ? String.format("One or both conditions (Name=%s, Description=%s) are too long: ", conditionOnName, conditionOnDescription) : e.getMessage()).errorCode(errorCode).bapiName("RFC_READ_TABLE").tableName("DD02T").build();
        }
        fields = function.getTableParameterList().getTable("FIELDS");
        Map<String, Integer> lengthIndex = this.getLengthIndex(fields);
        Map<String, Integer> offsetIndex = this.getOffsetIndex(fields);
        LinkedList<ISAPTable> tables = new LinkedList<ISAPTable>();
        JCoTable data = function.getTableParameterList().getTable("DATA");
        for (int i = 0; i < data.getNumRows(); ++i) {
            data.setRow(i);
            SAPTable table = new SAPTable();
            table.setDescription(this.extractFieldData(data.getString(0), "DDTEXT", offsetIndex, lengthIndex));
            table.setName(this.extractFieldData(data.getString(0), "TABNAME", offsetIndex, lengthIndex));
            tables.add(table);
        }
        return tables;
    }

    protected void addWhereClause(JCoTable options, String fieldName, String condition) {
        if (!this.isAll(condition)) {
            options.appendRow();
            options.setValue(0, (options.getNumRows() == 1 ? "" : "AND ") + this.getWhereClause(fieldName, condition));
        }
    }

    protected void addWhereLikeClause(JCoTable options, String fieldName, String condition) {
        if (!this.isAll(condition)) {
            options.appendRow();
            options.setValue(0, (options.getNumRows() == 1 ? "" : "AND ") + this.getWhereLikeClause(fieldName, condition));
        }
    }

    protected String extractFieldData(String wa, String fieldName, Map<String, Integer> offsetIndex, Map<String, Integer> lengthIndex) {
        return SAPUtil.extractFieldData(wa, fieldName, offsetIndex, lengthIndex);
    }

    protected Map<String, Integer> getLengthIndex(JCoTable fields) {
        HashMap<String, Integer> lengthIndex = new HashMap<String, Integer>();
        for (int i = 0; i < fields.getNumRows(); ++i) {
            fields.setRow(i);
            String fieldName = fields.getString("FIELDNAME");
            lengthIndex.put(fieldName, Integer.valueOf(fields.getString("LENGTH")));
        }
        return lengthIndex;
    }

    protected Map<String, Integer> getOffsetIndex(JCoTable fields) {
        HashMap<String, Integer> offsetIndex = new HashMap<String, Integer>();
        for (int i = 0; i < fields.getNumRows(); ++i) {
            fields.setRow(i);
            String fieldName = fields.getString("FIELDNAME");
            offsetIndex.put(fieldName, Integer.valueOf(fields.getString("OFFSET")));
        }
        return offsetIndex;
    }

    protected String getWhereClause(String fieldName, String condition) {
        int capacity = 5;
        capacity += fieldName.length();
        StringBuilder sb = new StringBuilder(capacity += condition.length());
        sb.append(fieldName);
        sb.append(" = ");
        sb.append("'");
        sb.append(condition);
        sb.append("'");
        return sb.toString();
    }

    protected String getWhereLikeClause(String fieldName, String condition) {
        int capacity = 8;
        capacity += fieldName.length();
        StringBuilder sb = new StringBuilder(capacity += condition.length());
        sb.append(fieldName);
        sb.append(" LIKE ");
        sb.append("'");
        sb.append(condition.replaceAll("\\*", "%"));
        sb.append("'");
        return sb.toString();
    }
}

