/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.ColumnName;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.TTL;
import com.datastax.spark.connector.WriteTime;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.CassandraTableRowReaderProvider;
import com.datastax.spark.connector.rdd.reader.RowReader;
import java.io.IOException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Session;

public abstract class CassandraTableRowReaderProvider$class {
    public static Option splitCount(CassandraTableRowReaderProvider $this) {
        return $this.readConf().splitCount();
    }

    public static long splitSize(CassandraTableRowReaderProvider $this) {
        return (long)$this.readConf().splitSizeInMB() * 1024L * 1024L;
    }

    public static int fetchSize(CassandraTableRowReaderProvider $this) {
        return $this.readConf().fetchSizeInRows();
    }

    public static ConsistencyLevel consistencyLevel(CassandraTableRowReaderProvider $this) {
        return $this.readConf().consistencyLevel();
    }

    public static RowReader rowReader(CassandraTableRowReaderProvider $this) {
        return $this.rowReaderFactory().rowReader($this.tableDef(), $this.columnNames().selectFrom($this.tableDef()));
    }

    public static TableDef tableDef(CassandraTableRowReaderProvider $this) {
        return Schema$.MODULE$.tableFromCassandra($this.connector(), $this.keyspaceName(), $this.tableName());
    }

    public static Seq checkColumnsExistence(CassandraTableRowReaderProvider $this, Seq columns) {
        Set allColumnNames = ((TraversableOnce)$this.tableDef().columns().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$1) {
                return x$1.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        Set regularColumnNames = ((TraversableOnce)$this.tableDef().regularColumns().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$2) {
                return x$2.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        return (Seq)columns.map((Function1)new Serializable($this, allColumnNames, regularColumnNames){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableRowReaderProvider $outer;
            private final Set allColumnNames$1;
            private final Set regularColumnNames$1;

            public final ColumnRef apply(ColumnRef column) {
                return CassandraTableRowReaderProvider$class.checkSingleColumn$1(this.$outer, column, this.allColumnNames$1, this.regularColumnNames$1);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.allColumnNames$1 = allColumnNames$1;
                this.regularColumnNames$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq selectedColumnRefs(CassandraTableRowReaderProvider $this) {
        ColumnSelector columnSelector;
        block5: {
            Option<Seq<ColumnRef>> option;
            block8: {
                Seq seq;
                block7: {
                    Seq providedColumns;
                    block6: {
                        Seq seq2;
                        block3: {
                            block4: {
                                block2: {
                                    columnSelector = $this.columnNames();
                                    AllColumns$ allColumns$ = AllColumns$.MODULE$;
                                    ColumnSelector columnSelector2 = columnSelector;
                                    if (allColumns$ != null ? !allColumns$.equals(columnSelector2) : columnSelector2 != null) break block2;
                                    seq2 = (Seq)$this.tableDef().columns().map((Function1)new Serializable($this){
                                        public static final long serialVersionUID = 0L;

                                        public final ColumnRef apply(ColumnDef col) {
                                            return package$.MODULE$.toNamedColumnRef(col.columnName());
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                PartitionKeyColumns$ partitionKeyColumns$ = PartitionKeyColumns$.MODULE$;
                                ColumnSelector columnSelector3 = columnSelector;
                                if (partitionKeyColumns$ != null ? !partitionKeyColumns$.equals(columnSelector3) : columnSelector3 != null) break block4;
                                seq2 = (Seq)$this.tableDef().partitionKey().map((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final ColumnRef apply(ColumnDef col) {
                                        return package$.MODULE$.toNamedColumnRef(col.columnName());
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(columnSelector instanceof SomeColumns)) break block5;
                            SomeColumns someColumns = (SomeColumns)columnSelector;
                            Seq<ColumnRef> cs = someColumns.columns();
                            seq2 = $this.checkColumnsExistence(cs);
                        }
                        providedColumns = seq2;
                        option = $this.rowReader().neededColumns();
                        if (!(option instanceof Some)) break block6;
                        Some some = (Some)option;
                        Seq neededColumns2 = (Seq)some.x();
                        seq = (Seq)providedColumns.filter((Function1)neededColumns2.toSet());
                        break block7;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Seq<ColumnRef>> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                    seq = providedColumns;
                }
                return seq;
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)columnSelector);
    }

    public static Seq narrowColumnSelection(CassandraTableRowReaderProvider $this, Seq columns) {
        ColumnSelector columnSelector;
        block5: {
            block3: {
                block4: {
                    block2: {
                        columnSelector = $this.columnNames();
                        if (!(columnSelector instanceof SomeColumns)) break block2;
                        SomeColumns someColumns = (SomeColumns)columnSelector;
                        Seq<ColumnRef> cs = someColumns.columns();
                        CassandraTableRowReaderProvider$class.checkColumnsAvailable($this, columns, cs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    AllColumns$ allColumns$ = AllColumns$.MODULE$;
                    ColumnSelector columnSelector2 = columnSelector;
                    if (allColumns$ != null ? !allColumns$.equals(columnSelector2) : columnSelector2 != null) break block4;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                PartitionKeyColumns$ partitionKeyColumns$ = PartitionKeyColumns$.MODULE$;
                ColumnSelector columnSelector3 = columnSelector;
                if (partitionKeyColumns$ != null ? !partitionKeyColumns$.equals(columnSelector3) : columnSelector3 != null) break block5;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return columns;
        }
        throw new MatchError((Object)columnSelector);
    }

    private static void checkColumnsAvailable(CassandraTableRowReaderProvider $this, Seq columns, Seq availableColumns) {
        Set availableColumnsSet = ((TraversableOnce)availableColumns.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ColumnName) {
                    ColumnName columnName2 = (ColumnName)A1;
                    String columnName3 = columnName2.columnName();
                    object = columnName3;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x1) {
                ColumnRef columnRef = x1;
                boolean bl = columnRef instanceof ColumnName;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Option notFound = columns.collectFirst((PartialFunction)new Serializable($this, availableColumnsSet){
            public static final long serialVersionUID = 0L;
            private final Set availableColumnsSet$1;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ColumnName columnName2;
                String columnName3;
                A1 A1 = x2;
                Object object = A1 instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName3 = (columnName2 = (ColumnName)A1).columnName())) ? columnName3 : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x2) {
                ColumnName columnName2;
                String columnName3;
                ColumnRef columnRef = x2;
                boolean bl = columnRef instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName3 = (columnName2 = (ColumnName)columnRef).columnName()));
                return bl;
            }
            {
                this.availableColumnsSet$1 = availableColumnsSet$1;
            }
        });
        if (notFound.isDefined()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column not found in selection: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{notFound.get()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Available columns: [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableColumns.mkString(",")}))).toString());
        }
    }

    public static String cassandraPartitionerClassName(CassandraTableRowReaderProvider $this) {
        return (String)$this.connector().withSessionDo(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Session session) {
                return session.execute("SELECT partitioner FROM system.local").one().getString(0);
            }
        });
    }

    public static RowReader verify(CassandraTableRowReaderProvider $this) {
        $this.tableDef().columns();
        return $this.rowReader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ColumnRef checkSingleColumn$1(CassandraTableRowReaderProvider $this, ColumnRef column, Set allColumnNames$1, Set regularColumnNames$1) {
        ColumnRef columnRef = column;
        if (columnRef instanceof ColumnName) {
            if (!allColumnNames$1.contains((Object)column.columnName())) throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " not found in table ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, $this.keyspaceName(), $this.tableName()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return column;
        } else if (columnRef instanceof TTL) {
            TTL tTL = (TTL)columnRef;
            String columnName2 = tTL.columnName();
            if (!regularColumnNames$1.contains((Object)columnName2)) throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL can be obtained only for regular columns, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but column ", " is not a regular column in table ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName2, $this.keyspaceName(), $this.tableName()}))).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return column;
        } else if (columnRef instanceof WriteTime) {
            WriteTime writeTime = (WriteTime)columnRef;
            String columnName3 = writeTime.columnName();
            if (!regularColumnNames$1.contains((Object)columnName3)) throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL can be obtained only for regular columns, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but column ", " is not a regular column in table ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName3, $this.keyspaceName(), $this.tableName()}))).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return column;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return column;
    }

    public static void $init$(CassandraTableRowReaderProvider $this) {
    }
}

