/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartitioner$;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001+\t\u0001ri\u0005\u0002\u0001#A\u0011!\u0003G\u0007\u0002')\u0011\u0011\u0002\u0006\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a'\tY\u0001+\u0019:uSRLwN\\3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u0002;bE2,\u0007CA\u000f$\u001d\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tz\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011-,\u0017p\u001d9bG\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0018a\u0006\u0014H/\u001b;j_:\u001c\b+\u001a:SKBd\u0017nY1TKR\u0004\"AH\u0016\n\u00051z\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\nqCJ$\u0018\u000e^5p].+\u00170T1qa\u0016\u0014\bC\u0001\u00192\u001b\u00051\u0011B\u0001\u001a\u0007\u00059\u0019u\u000e\\;n]N+G.Z2u_JD\u0001b\u0002\u0001\u0003\u0006\u0004%\t\u0001N\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HB\u0001\u0004GFd\u0017B\u0001\u001e8\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\u0011q\u0002!\u0011!Q\u0001\nU\n!bY8o]\u0016\u001cGo\u001c:!\u0011!q\u0004A!A!\u0002\u0017y\u0014aC2veJ,g\u000e\u001e+za\u0016\u00042\u0001Q\"F\u001b\u0005\t%B\u0001\" \u0003\u001d\u0011XM\u001a7fGRL!\u0001R!\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"AR$\r\u0001\u0011)\u0001\n\u0001b\u0001\u0013\n\tA+\u0005\u0002K\u001bB\u0011adS\u0005\u0003\u0019~\u0011qAT8uQ&tw\r\u0005\u0002\u001f\u001d&\u0011qj\b\u0002\u0004\u0003:L\b\u0002C)\u0001\u0005\u0003\u0005\u000b1\u0002*\u0002\u0007I<h\rE\u0002T-\u0016k\u0011\u0001\u0016\u0006\u0003+\u001a\taa\u001e:ji\u0016\u0014\u0018BA,U\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010\u000b\u0002Q3B\u0011aDW\u0005\u00037~\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0019yF-\u001a4hQR\u0019\u0001MY2\u0011\u0007\u0005\u0004Q)D\u0001\u0003\u0011\u0015qD\fq\u0001@\u0011\u0015\tF\fq\u0001S\u0011\u0015YB\f1\u0001\u001d\u0011\u00159C\f1\u0001\u001d\u0011\u0015IC\f1\u0001+\u0011\u0015qC\f1\u00010\u0011\u00159A\f1\u00016\u0011\u001dQ\u0007A1A\u0005\u0002-\f\u0001\u0002^1cY\u0016$UMZ\u000b\u0002YB\u0011a'\\\u0005\u0003]^\u0012\u0001\u0002V1cY\u0016$UM\u001a\u0005\u0007a\u0002\u0001\u000b\u0011\u00027\u0002\u0013Q\f'\r\\3EK\u001a\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta]\u0001\ne><xK]5uKJ,\u0012\u0001\u001e\t\u0004'V,\u0015B\u0001<U\u0005%\u0011vn^,sSR,'\u000f\u0003\u0004y\u0001\u0001\u0006I\u0001^\u0001\u000be><xK]5uKJ\u0004\u0003\"\u0003>\u0001\u0011\u000b\u0007I\u0011\u0001\u0005|\u00039!xn[3o\u000f\u0016tWM]1u_J,\u0012\u0001 \t\u0004Cv,\u0015B\u0001@\u0003\u00059!vn[3o\u000f\u0016tWM]1u_JD\u0011\"!\u0001\u0001\u0011\u0003\u0005\u000b\u0015\u0002?\u0002\u001fQ|7.\u001a8HK:,'/\u0019;pe\u0002B#a`-\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI!\u0001\u0005nKR\fG-\u0019;b+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t\r|'/\u001a\u0006\u0004\u0003+Q\u0011A\u00023sSZ,'/\u0003\u0003\u0002\u001a\u0005=!\u0001C'fi\u0006$\u0017\r^1\t\u0015\u0005u\u0001\u0001#A!B\u0013\tY!A\u0005nKR\fG-\u0019;bA!\u001a\u00111D-\t\u0015\u0005\r\u0002\u0001#b\u0001\n\u0013\t)#A\bqe>$xnY8m-\u0016\u00148/[8o+\t\t9\u0003\u0005\u0003\u0002\u000e\u0005%\u0012\u0002BA\u0016\u0003\u001f\u0011q\u0002\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0005\u000b\u0003_\u0001\u0001\u0012!Q!\n\u0005\u001d\u0012\u0001\u00059s_R|7m\u001c7WKJ\u001c\u0018n\u001c8!Q\r\ti#\u0017\u0005\u000b\u0003k\u0001\u0001R1A\u0005\n\u0005]\u0012!B2mCjTXCAA\u001da\u0011\tY$!\u0014\u0011\r\u0005u\u0012qIA&\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyDA\u0003DY\u0006\u001c8\u000fE\u0002G\u0003\u001b\"1\"a\u0014\u0002R\u0005\u0005\t\u0011!B\u0001\u0013\n\u0019q\fJ\u0019\t\u0015\u0005M\u0003\u0001#A!B\u0013\tI$\u0001\u0004dY\u0006T(\u0010\t\u0015\u0004\u0003#J\u0006\"CA-\u0001\t\u0007I\u0011BA.\u0003\u0015Awn\u001d;t+\t\ti\u0006\u0005\u0004\u0002`\u0005=\u0014Q\u000f\b\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005%TBAA3\u0015\r\t9GD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J1!!\u001c \u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001d\u0002t\t1a+Z2u_JT1!!\u001c !\u0011\t9(! \u000e\u0005\u0005e$\u0002BA>\u0003\u0007\n1A\\3u\u0013\u0011\ty(!\u001f\u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002^\u00051\u0001n\\:ug\u0002B\u0011\"a\"\u0001\u0005\u0004%I!!#\u0002\u000f!|7\u000f^*fiV\u0011\u00111\u0012\t\u0006;\u00055\u0015QO\u0005\u0004\u0003\u001f+#aA*fi\"A\u00111\u0013\u0001!\u0002\u0013\tY)\u0001\u0005i_N$8+\u001a;!\u0011%\t9\n\u0001b\u0001\n\u0013\tI*\u0001\u0005ok6Dun\u001d;t+\u0005Q\u0003bBAO\u0001\u0001\u0006IAK\u0001\n]Vl\u0007j\\:ug\u0002B\u0011\"!)\u0001\u0005\u0004%I!a)\u0002!A\f'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001cXCAAS!\u0019\ty&a*\u0002,&!\u0011\u0011VA:\u0005\u0011a\u0015n\u001d;\u0011\u000b\u00055\u0016q\u0017\u0016\u000e\u0005\u0005=&\u0002BAY\u0003g\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005Uv$\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00020\nQ\u0011J\u001c3fq\u0016$7+Z9\t\u0011\u0005u\u0006\u0001)A\u0005\u0003K\u000b\u0011\u0003]1si&$\u0018n\u001c8J]\u0012,\u00070Z:!\u0011%\t\t\r\u0001b\u0001\n\u0013\t\u0019-A\u0004i_N$X*\u00199\u0016\u0005\u0005\u0015\u0007\u0003CAW\u0003\u000f\f)(a+\n\t\u0005%\u0017q\u0016\u0002\u0004\u001b\u0006\u0004\b\u0002CAg\u0001\u0001\u0006I!!2\u0002\u0011!|7\u000f^'ba\u0002B\u0011\"!5\u0001\u0005\u0004%I!a5\u0002\u0011%tG-\u001a=NCB,\"!!6\u0011\u000f\u00055\u0016q\u0019\u0016\u0002v!A\u0011\u0011\u001c\u0001!\u0002\u0013\t).A\u0005j]\u0012,\u00070T1qA!9\u0011Q\u001c\u0001\u0005\n\u0005}\u0017!C1cg6{G-\u001e7p)\u0015Q\u0013\u0011]As\u0011\u001d\t\u0019/a7A\u0002)\n\u0001\u0002Z5wS\u0012,g\u000e\u001a\u0005\b\u0003O\fY\u000e1\u0001+\u0003\u001d!\u0017N^5t_JDq!a;\u0001\t\u0013\ti/\u0001\u0006sC:$w.\u001c%pgR$B!!\u001e\u0002p\"9\u0011\u0011_Au\u0001\u0004Q\u0013!B5oI\u0016D\bbBA{\u0001\u0011\u0005\u0013q_\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0004U\u0005e\bbBA~\u0003g\u0004\r!T\u0001\u0004W\u0016L\bbBA\u0000\u0001\u0011\u0005\u0013\u0011T\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006\u0005!r-\u001a;F]\u0012\u0004x.\u001b8u!\u0006\u0014H/\u001b;j_:$BAa\u0002\u0003\u000eA\u0019\u0011M!\u0003\n\u0007\t-!A\u0001\tSKBd\u0017nY1QCJ$\u0018\u000e^5p]\"A!q\u0002B\u0001\u0001\u0004\u0011\t\"A\u0005qCJ$\u0018\u000e^5p]B\u0019!Ca\u0005\n\u0007\tU1CA\u0005QCJ$\u0018\u000e^5p]\u0002")
public class ReplicaPartitioner<T>
extends Partitioner {
    private final String keyspace;
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private transient TokenGenerator<T> tokenGenerator;
    private transient Metadata metadata;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private volatile transient byte bitmap$trans$0;

    private TokenGenerator tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.tokenGenerator;
        }
    }

    private Metadata metadata$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadata = (Metadata)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Metadata apply(Cluster x$1) {
                        return x$1.getMetadata();
                    }
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.metadata;
        }
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)((Object)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ProtocolVersion apply(Cluster x$2) {
                        return x$2.getConfiguration().getProtocolOptions().getProtocolVersion();
                    }
                }));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.protocolVersion;
        }
    }

    private Class clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.clazz;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    public TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Metadata metadata() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            int n;
            ByteBuffer keyBuffer = this.tokenGenerator().getPartitionKeyBufferFor(object);
            int keyHash = Math.abs(keyBuffer.hashCode());
            Set replicas = (Set)JavaConversions$.MODULE$.asScalaSet(this.metadata().getReplicas(this.keyspace, keyBuffer)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InetAddress apply(Host x$4) {
                    return x$4.getBroadcastAddress();
                }
            }, Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(keyHash, replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(keyHash))).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (scala.collection.immutable.Set<InetAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.keyspace = keyspace;
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = connector.hosts().toVector();
        this.hostSet = connector.hosts();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new $anonfun$1(this)).flatMap((Function1)new $anonfun$2(this), Map$.MODULE$.canBuildFrom());
    }
}

