/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.Clock;
import shade.com.datastax.spark.connector.driver.core.SystemClock;
import shade.com.datastax.spark.connector.driver.core.TimestampGenerator;

abstract class AbstractMonotonicTimestampGenerator
implements TimestampGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonotonicTimestampGenerator.class);
    volatile Clock clock = new SystemClock();

    AbstractMonotonicTimestampGenerator() {
    }

    protected long computeNext(long last) {
        long millis = last / 1000L;
        long counter = last % 1000L;
        long now = this.clock.currentTime();
        if (millis >= now) {
            if (counter == 999L) {
                logger.warn("Sub-millisecond counter overflowed, some query timestamps will not be distinct");
            } else {
                ++counter;
            }
        } else {
            millis = now;
            counter = 0L;
        }
        return millis * 1000L + counter;
    }
}

