/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.ArrayBackedRow;
import shade.com.datastax.spark.connector.driver.core.BatchStatement;
import shade.com.datastax.spark.connector.driver.core.BoundStatement;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ColumnDefinitions;
import shade.com.datastax.spark.connector.driver.core.Connection;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.DriverThrowables;
import shade.com.datastax.spark.connector.driver.core.ExecutionInfo;
import shade.com.datastax.spark.connector.driver.core.Message;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.QueryTrace;
import shade.com.datastax.spark.connector.driver.core.RequestHandler;
import shade.com.datastax.spark.connector.driver.core.Responses;
import shade.com.datastax.spark.connector.driver.core.ResultSet;
import shade.com.datastax.spark.connector.driver.core.Row;
import shade.com.datastax.spark.connector.driver.core.SessionManager;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.Token;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.exceptions.ConnectionException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.SettableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Uninterruptibles;

abstract class ArrayBackedResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(ResultSet.class);
    private static final Queue<List<ByteBuffer>> EMPTY_QUEUE = new ArrayDeque<List<ByteBuffer>>(0);
    protected final ColumnDefinitions metadata;
    protected final Token.Factory tokenFactory;
    private final boolean wasApplied;
    protected final ProtocolVersion protocolVersion;
    protected final CodecRegistry codecRegistry;

    private ArrayBackedResultSet(ColumnDefinitions metadata2, Token.Factory tokenFactory, List<ByteBuffer> firstRow, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        this.metadata = metadata2;
        this.protocolVersion = protocolVersion2;
        this.codecRegistry = codecRegistry;
        this.tokenFactory = tokenFactory;
        this.wasApplied = ArrayBackedResultSet.checkWasApplied(firstRow, metadata2, protocolVersion2);
    }

    static ArrayBackedResultSet fromMessage(Responses.Result msg, SessionManager session, ProtocolVersion protocolVersion2, ExecutionInfo info, Statement statement) {
        info = ArrayBackedResultSet.update(info, msg, session);
        switch (msg.kind) {
            case VOID: {
                return ArrayBackedResultSet.empty(info);
            }
            case ROWS: {
                Token.Factory tokenFactory;
                ColumnDefinitions columnDefs;
                Responses.Result.Rows r = (Responses.Result.Rows)msg;
                if (r.metadata.columns == null) {
                    assert (statement instanceof BoundStatement);
                    columnDefs = ((BoundStatement)statement).statement.getPreparedId().resultSetMetadata;
                    assert (columnDefs != null);
                } else {
                    columnDefs = r.metadata.columns;
                }
                Token.Factory factory = tokenFactory = session == null ? null : session.getCluster().manager.metadata.tokenFactory();
                assert (r.metadata.pagingState == null || info != null);
                return r.metadata.pagingState == null ? new SinglePage(columnDefs, tokenFactory, protocolVersion2, columnDefs.codecRegistry, r.data, info) : new MultiPage(columnDefs, tokenFactory, protocolVersion2, columnDefs.codecRegistry, r.data, info, r.metadata.pagingState, session, statement);
            }
            case SET_KEYSPACE: 
            case SCHEMA_CHANGE: {
                return ArrayBackedResultSet.empty(info);
            }
            case PREPARED: {
                throw new RuntimeException("Prepared statement received when a ResultSet was expected");
            }
        }
        logger.error("Received unknown result type '{}'; returning empty result set", (Object)msg.kind);
        return ArrayBackedResultSet.empty(info);
    }

    private static ExecutionInfo update(ExecutionInfo info, Responses.Result msg, SessionManager session) {
        if (info == null) {
            return null;
        }
        UUID tracingId = msg.getTracingId();
        QueryTrace trace = tracingId == null ? null : new QueryTrace(tracingId, session);
        return info.withTraceAndWarnings(trace, msg.warnings);
    }

    private static ArrayBackedResultSet empty(ExecutionInfo info) {
        return new SinglePage(ColumnDefinitions.EMPTY, null, null, null, EMPTY_QUEUE, info);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        ArrayList<Row> result = new ArrayList<Row>(this.getAvailableWithoutFetching());
        for (Row row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !ArrayBackedResultSet.this.isExhausted();
            }

            @Override
            public Row next() {
                return ArrayBackedResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSet[ exhausted: ").append(this.isExhausted());
        sb.append(", ").append(this.metadata).append(']');
        return sb.toString();
    }

    private static boolean checkWasApplied(List<ByteBuffer> firstRow, ColumnDefinitions metadata2, ProtocolVersion protocolVersion2) {
        if (firstRow == null) {
            return true;
        }
        int[] is = metadata2.findAllIdx("[applied]");
        if (is == null) {
            return true;
        }
        int i = is[0];
        if (!DataType.cboolean().equals(metadata2.getType(i))) {
            return true;
        }
        ByteBuffer value2 = firstRow.get(i);
        if (value2 == null || value2.remaining() == 0) {
            return false;
        }
        return TypeCodec.cboolean().deserializeNoBoxing(value2, protocolVersion2);
    }

    private static class MultiPage
    extends ArrayBackedResultSet {
        private Queue<List<ByteBuffer>> currentPage;
        private final Queue<Queue<List<ByteBuffer>>> nextPages = new ConcurrentLinkedQueue<Queue<List<ByteBuffer>>>();
        private final Deque<ExecutionInfo> infos = new LinkedBlockingDeque<ExecutionInfo>();
        private volatile FetchingState fetchState;
        private final SessionManager session;
        private final Statement statement;

        private MultiPage(ColumnDefinitions metadata2, Token.Factory tokenFactory, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry, Queue<List<ByteBuffer>> rows, ExecutionInfo info, ByteBuffer pagingState, SessionManager session, Statement statement) {
            super(metadata2, tokenFactory, rows.peek(), protocolVersion2, codecRegistry);
            this.currentPage = rows;
            this.infos.offer(info.withPagingState(pagingState, protocolVersion2, codecRegistry).withStatement(statement));
            this.fetchState = new FetchingState(pagingState, null);
            this.session = session;
            this.statement = statement;
        }

        @Override
        public boolean isExhausted() {
            this.prepareNextRow();
            return this.currentPage.isEmpty();
        }

        @Override
        public Row one() {
            this.prepareNextRow();
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.protocolVersion, this.currentPage.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            int available = this.currentPage.size();
            for (Queue queue : this.nextPages) {
                available += queue.size();
            }
            return available;
        }

        @Override
        public boolean isFullyFetched() {
            return this.fetchState == null;
        }

        private void prepareNextRow() {
            while (this.currentPage.isEmpty()) {
                FetchingState fetchingState = this.fetchState;
                Queue<List<ByteBuffer>> nextPage = this.nextPages.poll();
                if (nextPage != null) {
                    this.currentPage = nextPage;
                    continue;
                }
                if (fetchingState == null) {
                    return;
                }
                try {
                    Uninterruptibles.getUninterruptibly(this.fetchMoreResults());
                }
                catch (ExecutionException e) {
                    throw DriverThrowables.propagateCause(e);
                }
            }
        }

        @Override
        public ListenableFuture<ResultSet> fetchMoreResults() {
            return this.fetchMoreResults(this.fetchState);
        }

        private ListenableFuture<ResultSet> fetchMoreResults(FetchingState fetchState) {
            if (fetchState == null) {
                return Futures.immediateFuture(this);
            }
            if (fetchState.inProgress != null) {
                return fetchState.inProgress;
            }
            assert (fetchState.nextStart != null);
            ByteBuffer state = fetchState.nextStart;
            SettableFuture<ResultSet> future = SettableFuture.create();
            this.fetchState = new FetchingState(null, future);
            return this.queryNextPage(state, future);
        }

        private ListenableFuture<ResultSet> queryNextPage(ByteBuffer nextStart, final SettableFuture<ResultSet> future) {
            assert (!(this.statement instanceof BatchStatement));
            final Message.Request request = this.session.makeRequestMessage(this.statement, nextStart);
            this.session.execute(new RequestHandler.Callback(){

                @Override
                public Message.Request request() {
                    return request;
                }

                @Override
                public void register(RequestHandler handler) {
                }

                @Override
                public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
                    try {
                        switch (response.type) {
                            case RESULT: {
                                Responses.Result rm = (Responses.Result)response;
                                info = ArrayBackedResultSet.update(info, rm, MultiPage.this.session);
                                if (rm.kind == Responses.Result.Kind.ROWS) {
                                    Responses.Result.Rows rows = (Responses.Result.Rows)rm;
                                    if (rows.metadata.pagingState != null) {
                                        info = info.withPagingState(rows.metadata.pagingState, MultiPage.this.protocolVersion, MultiPage.this.codecRegistry).withStatement(statement);
                                    }
                                    MultiPage.this.nextPages.offer(rows.data);
                                    MultiPage.this.fetchState = rows.metadata.pagingState == null ? null : new FetchingState(rows.metadata.pagingState, null);
                                } else if (rm.kind == Responses.Result.Kind.VOID) {
                                    MultiPage.this.fetchState = null;
                                } else {
                                    logger.error("Received unknown result type '{}' during paging: ignoring message", (Object)rm.kind);
                                    connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s result response", new Object[]{rm.kind})));
                                    future.setException(new DriverInternalError(String.format("Got unexpected %s result response from %s", new Object[]{rm.kind, connection.address})));
                                    return;
                                }
                                MultiPage.this.infos.offer(info);
                                future.set(MultiPage.this);
                                break;
                            }
                            case ERROR: {
                                future.setException(((Responses.Error)response).asException(connection.address));
                                break;
                            }
                            default: {
                                connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                                future.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                                break;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        future.setException(new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
                    }
                }

                @Override
                public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                    this.onSet(connection, response, null, null, latency);
                }

                @Override
                public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                    future.setException(exception);
                }

                @Override
                public boolean onTimeout(Connection connection, long latency, int retryCount) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int retryCount() {
                    return 0;
                }
            }, this.statement);
            return future;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.infos.getLast();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return new ArrayList<ExecutionInfo>(this.infos);
        }

        private static class FetchingState {
            public final ByteBuffer nextStart;
            public final ListenableFuture<ResultSet> inProgress;

            FetchingState(ByteBuffer nextStart, ListenableFuture<ResultSet> inProgress) {
                assert (nextStart == null != (inProgress == null));
                this.nextStart = nextStart;
                this.inProgress = inProgress;
            }
        }
    }

    private static class SinglePage
    extends ArrayBackedResultSet {
        private final Queue<List<ByteBuffer>> rows;
        private final ExecutionInfo info;

        private SinglePage(ColumnDefinitions metadata2, Token.Factory tokenFactory, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry, Queue<List<ByteBuffer>> rows, ExecutionInfo info) {
            super(metadata2, tokenFactory, rows.peek(), protocolVersion2, codecRegistry);
            this.info = info;
            this.rows = rows;
        }

        @Override
        public boolean isExhausted() {
            return this.rows.isEmpty();
        }

        @Override
        public Row one() {
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.protocolVersion, this.rows.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            return this.rows.size();
        }

        @Override
        public boolean isFullyFetched() {
            return true;
        }

        @Override
        public ListenableFuture<ResultSet> fetchMoreResults() {
            return Futures.immediateFuture(this);
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.info;
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return Collections.singletonList(this.info);
        }
    }
}

