/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.regex.Pattern;
import shade.com.datastax.spark.connector.driver.core.AbstractGettableData;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ColumnDefinitions;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.Row;
import shade.com.datastax.spark.connector.driver.core.Token;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;

class ArrayBackedRow
extends AbstractGettableData
implements Row {
    private static final Pattern TOKEN_COLUMN_NAME = Pattern.compile("(system\\.)?token(.*)");
    private final ColumnDefinitions metadata;
    private final Token.Factory tokenFactory;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata2, Token.Factory tokenFactory, ProtocolVersion protocolVersion2, List<ByteBuffer> data) {
        super(protocolVersion2);
        this.metadata = metadata2;
        this.tokenFactory = tokenFactory;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata2, Token.Factory tokenFactory, ProtocolVersion protocolVersion2, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new ArrayBackedRow(metadata2, tokenFactory, protocolVersion2, data);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    protected DataType getType(int i) {
        return this.metadata.getType(i);
    }

    @Override
    protected String getName(int i) {
        return this.metadata.getName(i);
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.data.get(i);
    }

    @Override
    protected CodecRegistry getCodecRegistry() {
        return this.metadata.codecRegistry;
    }

    @Override
    protected int getIndexOf(String name) {
        return this.metadata.getFirstIdx(name);
    }

    @Override
    public Token getToken(int i) {
        if (this.tokenFactory == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        this.checkType(i, this.tokenFactory.getTokenType().getName());
        ByteBuffer value2 = this.data.get(i);
        if (value2 == null || value2.remaining() == 0) {
            return null;
        }
        return this.tokenFactory.deserialize(value2, this.protocolVersion);
    }

    @Override
    public Token getToken(String name) {
        return this.getToken(this.metadata.getFirstIdx(name));
    }

    @Override
    public Token getPartitionKeyToken() {
        int i = 0;
        for (ColumnDefinitions.Definition column : this.metadata) {
            if (TOKEN_COLUMN_NAME.matcher(column.getName()).matches()) {
                return this.getToken(i);
            }
            ++i;
        }
        throw new IllegalStateException("Found no column named 'token(...)'. If the column is aliased, use getToken(String).");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.getCodecRegistry().codecFor(this.metadata.getType(i)).deserialize(bb, this.protocolVersion).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

