/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.TupleType;
import shade.com.datastax.spark.connector.driver.core.TupleValue;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.UDTValue;
import shade.com.datastax.spark.connector.driver.core.UserType;
import shade.com.datastax.spark.connector.driver.core.exceptions.CodecNotFoundException;
import shade.com.datastax.spark.connector.google.common.base.Objects;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.cache.CacheBuilder;
import shade.com.datastax.spark.connector.google.common.cache.CacheLoader;
import shade.com.datastax.spark.connector.google.common.cache.LoadingCache;
import shade.com.datastax.spark.connector.google.common.cache.RemovalListener;
import shade.com.datastax.spark.connector.google.common.cache.RemovalNotification;
import shade.com.datastax.spark.connector.google.common.cache.Weigher;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;
import shade.com.datastax.spark.connector.google.common.util.concurrent.UncheckedExecutionException;

public final class CodecRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CodecRegistry.class);
    private static final ImmutableSet<TypeCodec<?>> PRIMITIVE_CODECS = ImmutableSet.of(TypeCodec.blob(), TypeCodec.cboolean(), TypeCodec.smallInt(), TypeCodec.tinyInt(), TypeCodec.cint(), TypeCodec.bigint(), new TypeCodec[]{TypeCodec.counter(), TypeCodec.cdouble(), TypeCodec.cfloat(), TypeCodec.varint(), TypeCodec.decimal(), TypeCodec.varchar(), TypeCodec.ascii(), TypeCodec.timestamp(), TypeCodec.date(), TypeCodec.time(), TypeCodec.uuid(), TypeCodec.timeUUID(), TypeCodec.inet()});
    public static final CodecRegistry DEFAULT_INSTANCE = new CodecRegistry();
    private final CopyOnWriteArrayList<TypeCodec<?>> codecs = new CopyOnWriteArrayList(PRIMITIVE_CODECS);
    private final LoadingCache<CacheKey, TypeCodec<?>> cache = this.defaultCacheBuilder().build(new TypeCodecCacheLoader());

    private CacheBuilder<CacheKey, TypeCodec<?>> defaultCacheBuilder() {
        CacheBuilder<CacheKey, TypeCodec<Object>> builder = CacheBuilder.newBuilder().initialCapacity(100).maximumWeight(1000L).weigher(new TypeCodecWeigher());
        if (logger.isTraceEnabled()) {
            builder = builder.removalListener(new TypeCodecRemovalListener());
        }
        return builder;
    }

    public CodecRegistry register(TypeCodec<?> newCodec) {
        for (TypeCodec<?> oldCodec : this.codecs) {
            if (!oldCodec.accepts(newCodec.getCqlType()) || !oldCodec.accepts(newCodec.getJavaType())) continue;
            logger.warn("Ignoring codec {} because it collides with previously registered codec {}", newCodec, oldCodec);
            return this;
        }
        CacheKey key = new CacheKey(newCodec.getCqlType(), newCodec.getJavaType());
        TypeCodec existing = (TypeCodec)this.cache.getIfPresent(key);
        if (existing != null) {
            logger.warn("Ignoring codec {} because it collides with previously generated codec {}", newCodec, (Object)existing);
            return this;
        }
        this.codecs.add(newCodec);
        return this;
    }

    public CodecRegistry register(TypeCodec<?> ... codecs) {
        for (TypeCodec<?> codec : codecs) {
            this.register(codec);
        }
        return this;
    }

    public CodecRegistry register(Iterable<? extends TypeCodec<?>> codecs) {
        for (TypeCodec<?> codec : codecs) {
            this.register(codec);
        }
        return this;
    }

    public <T> TypeCodec<T> codecFor(T value2) {
        return this.findCodec(null, value2);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType) throws CodecNotFoundException {
        return this.lookupCodec(cqlType, null);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, Class<T> javaType) throws CodecNotFoundException {
        return this.codecFor(cqlType, (T)TypeToken.of(javaType));
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, TypeToken<T> javaType) throws CodecNotFoundException {
        return this.lookupCodec(cqlType, javaType);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, T value2) {
        return this.findCodec(cqlType, value2);
    }

    private <T> TypeCodec<T> lookupCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Querying cache for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), (Object)CodecRegistry.toString(javaType));
        }
        CacheKey cacheKey = new CacheKey(cqlType, javaType);
        try {
            TypeCodec<?> codec = this.cache.get(cacheKey);
            logger.trace("Returning cached codec {}", codec);
            return codec;
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof CodecNotFoundException) {
                throw (CodecNotFoundException)e.getCause();
            }
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
        catch (RuntimeException e) {
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
        catch (ExecutionException e) {
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
    }

    private <T> TypeCodec<T> findCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), (Object)CodecRegistry.toString(javaType));
        }
        for (TypeCodec<?> codec : this.codecs) {
            if (!codec.accepts(cqlType) || javaType != null && !codec.accepts(javaType)) continue;
            logger.trace("Codec found: {}", codec);
            return codec;
        }
        return this.createCodec(cqlType, (T)javaType);
    }

    private <T> TypeCodec<T> findCodec(DataType cqlType, T value2) {
        Preconditions.checkNotNull(value2, "Parameter value cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), value2.getClass());
        }
        for (TypeCodec<?> codec : this.codecs) {
            if (cqlType != null && !codec.accepts(cqlType) || !codec.accepts(value2)) continue;
            logger.trace("Codec found: {}", codec);
            return codec;
        }
        return this.createCodec(cqlType, value2);
    }

    private <T> TypeCodec<T> createCodec(DataType cqlType, TypeToken<T> javaType) {
        TypeCodec<TypeToken<T>> codec = this.maybeCreateCodec(cqlType, (T)javaType);
        if (codec == null) {
            throw CodecRegistry.notFound(cqlType, javaType);
        }
        if (!codec.accepts(cqlType) || javaType != null && !codec.accepts(javaType)) {
            throw CodecRegistry.notFound(cqlType, javaType);
        }
        logger.trace("Codec created: {}", codec);
        return codec;
    }

    private <T> TypeCodec<T> createCodec(DataType cqlType, T value2) {
        TypeCodec<T> codec = this.maybeCreateCodec(cqlType, value2);
        if (codec == null) {
            throw CodecRegistry.notFound(cqlType, TypeToken.of(value2.getClass()));
        }
        if (cqlType != null && !codec.accepts(cqlType) || !codec.accepts(value2)) {
            throw CodecRegistry.notFound(cqlType, TypeToken.of(value2.getClass()));
        }
        logger.trace("Codec created: {}", codec);
        return codec;
    }

    private <T> TypeCodec<T> maybeCreateCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType);
        if (cqlType.getName() == DataType.Name.LIST && (javaType == null || List.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> elementType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                elementType = TypeToken.of(typeArguments[0]);
            }
            TypeCodec<Object> eltCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)elementType);
            return TypeCodec.list(eltCodec);
        }
        if (cqlType.getName() == DataType.Name.SET && (javaType == null || Set.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> elementType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                elementType = TypeToken.of(typeArguments[0]);
            }
            TypeCodec<Object> eltCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)elementType);
            return TypeCodec.set(eltCodec);
        }
        if (cqlType.getName() == DataType.Name.MAP && (javaType == null || Map.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> keyType = null;
            TypeToken<?> valueType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                keyType = TypeToken.of(typeArguments[0]);
                valueType = TypeToken.of(typeArguments[1]);
            }
            TypeCodec<Object> keyCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)keyType);
            TypeCodec<Object> valueCodec = this.findCodec(cqlType.getTypeArguments().get(1), (T)valueType);
            return TypeCodec.map(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType && (javaType == null || TupleValue.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.tuple((TupleType)cqlType);
        }
        if (cqlType instanceof UserType && (javaType == null || UDTValue.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.userType((UserType)cqlType);
        }
        if (cqlType instanceof DataType.CustomType && (javaType == null || ByteBuffer.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.custom((DataType.CustomType)cqlType);
        }
        return null;
    }

    private <T> TypeCodec<T> maybeCreateCodec(DataType cqlType, T value2) {
        Preconditions.checkNotNull(value2);
        if ((cqlType == null || cqlType.getName() == DataType.Name.LIST) && value2 instanceof List) {
            List list = (List)value2;
            if (list.isEmpty()) {
                DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? DataType.blob() : cqlType.getTypeArguments().get(0);
                return TypeCodec.list(this.findCodec(elementType, (T)null));
            }
            DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? null : cqlType.getTypeArguments().get(0);
            return TypeCodec.list(this.findCodec(elementType, list.iterator().next()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.SET) && value2 instanceof Set) {
            Set set = (Set)value2;
            if (set.isEmpty()) {
                DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? DataType.blob() : cqlType.getTypeArguments().get(0);
                return TypeCodec.set(this.findCodec(elementType, (T)null));
            }
            DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? null : cqlType.getTypeArguments().get(0);
            return TypeCodec.set(this.findCodec(elementType, set.iterator().next()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.MAP) && value2 instanceof Map) {
            Map map = (Map)value2;
            if (map.isEmpty()) {
                DataType keyType = cqlType == null || cqlType.getTypeArguments().size() < 1 ? DataType.blob() : cqlType.getTypeArguments().get(0);
                DataType valueType = cqlType == null || cqlType.getTypeArguments().size() < 2 ? DataType.blob() : cqlType.getTypeArguments().get(1);
                return TypeCodec.map(this.findCodec(keyType, (T)null), this.findCodec(valueType, (T)null));
            }
            DataType keyType = cqlType == null || cqlType.getTypeArguments().size() < 1 ? null : cqlType.getTypeArguments().get(0);
            DataType valueType = cqlType == null || cqlType.getTypeArguments().size() < 2 ? null : cqlType.getTypeArguments().get(1);
            Map.Entry entry = map.entrySet().iterator().next();
            return TypeCodec.map(this.findCodec(keyType, entry.getKey()), this.findCodec(valueType, entry.getValue()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.TUPLE) && value2 instanceof TupleValue) {
            return TypeCodec.tuple(cqlType == null ? ((TupleValue)value2).getType() : (TupleType)cqlType);
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.UDT) && value2 instanceof UDTValue) {
            return TypeCodec.userType(cqlType == null ? ((UDTValue)value2).getType() : (UserType)cqlType);
        }
        if (cqlType != null && cqlType instanceof DataType.CustomType && value2 instanceof ByteBuffer) {
            return TypeCodec.custom((DataType.CustomType)cqlType);
        }
        return null;
    }

    private static CodecNotFoundException notFound(DataType cqlType, TypeToken<?> javaType) {
        String msg = String.format("Codec not found for requested operation: [%s <-> %s]", CodecRegistry.toString(cqlType), CodecRegistry.toString(javaType));
        return new CodecNotFoundException(msg, cqlType, javaType);
    }

    private static String toString(Object value2) {
        return value2 == null ? "ANY" : value2.toString();
    }

    private class TypeCodecRemovalListener
    implements RemovalListener<CacheKey, TypeCodec<?>> {
        private TypeCodecRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<CacheKey, TypeCodec<?>> notification) {
            logger.trace("Evicting codec from cache: {} (cause: {})", notification.getValue(), (Object)notification.getCause());
        }
    }

    private class TypeCodecWeigher
    implements Weigher<CacheKey, TypeCodec<?>> {
        private TypeCodecWeigher() {
        }

        @Override
        public int weigh(CacheKey key, TypeCodec<?> value2) {
            return CodecRegistry.this.codecs.contains(value2) ? 0 : this.weigh(value2.cqlType, 0);
        }

        @Override
        private int weigh(DataType cqlType, int level) {
            switch (cqlType.getName()) {
                case LIST: 
                case SET: 
                case MAP: {
                    int weight = level;
                    for (DataType eltType : cqlType.getTypeArguments()) {
                        weight += this.weigh(eltType, level + 1);
                    }
                    return weight;
                }
                case UDT: {
                    int weight = level;
                    for (UserType.Field field : (UserType)cqlType) {
                        weight += this.weigh(field.getType(), level + 1);
                    }
                    return weight == 0 ? 1 : weight;
                }
                case TUPLE: {
                    int weight = level;
                    for (DataType componentType : ((TupleType)cqlType).getComponentTypes()) {
                        weight += this.weigh(componentType, level + 1);
                    }
                    return weight == 0 ? 1 : weight;
                }
                case CUSTOM: {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class TypeCodecCacheLoader
    extends CacheLoader<CacheKey, TypeCodec<?>> {
        private TypeCodecCacheLoader() {
        }

        @Override
        public TypeCodec<?> load(CacheKey cacheKey) {
            return CodecRegistry.this.findCodec(cacheKey.cqlType, (Object)cacheKey.javaType);
        }
    }

    private static final class CacheKey {
        private final DataType cqlType;
        private final TypeToken<?> javaType;

        public CacheKey(DataType cqlType, TypeToken<?> javaType) {
            this.javaType = javaType;
            this.cqlType = cqlType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equal(this.cqlType, cacheKey.cqlType) && Objects.equal(this.javaType, cacheKey.javaType);
        }

        public int hashCode() {
            return Objects.hashCode(this.cqlType, this.javaType);
        }
    }
}

