/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.AggregateMetadata;
import shade.com.datastax.spark.connector.driver.core.ArrayBackedResultSet;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Connection;
import shade.com.datastax.spark.connector.driver.core.DriverThrowables;
import shade.com.datastax.spark.connector.driver.core.ExecutionInfo;
import shade.com.datastax.spark.connector.driver.core.FunctionMetadata;
import shade.com.datastax.spark.connector.driver.core.KeyspaceMetadata;
import shade.com.datastax.spark.connector.driver.core.MaterializedViewMetadata;
import shade.com.datastax.spark.connector.driver.core.Message;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.RequestHandler;
import shade.com.datastax.spark.connector.driver.core.Responses;
import shade.com.datastax.spark.connector.driver.core.ResultSet;
import shade.com.datastax.spark.connector.driver.core.ResultSetFuture;
import shade.com.datastax.spark.connector.driver.core.SchemaElement;
import shade.com.datastax.spark.connector.driver.core.SessionManager;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.UserType;
import shade.com.datastax.spark.connector.driver.core.exceptions.ConnectionException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;
import shade.com.datastax.spark.connector.driver.core.exceptions.OperationTimedOutException;
import shade.com.datastax.spark.connector.google.common.util.concurrent.AbstractFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Uninterruptibles;

class DefaultResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture,
RequestHandler.Callback {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetFuture.class);
    private final SessionManager session;
    private final ProtocolVersion protocolVersion;
    private final Message.Request request;
    private volatile RequestHandler handler;

    DefaultResultSetFuture(SessionManager session, ProtocolVersion protocolVersion2, Message.Request request) {
        this.session = session;
        this.protocolVersion = protocolVersion2;
        this.request = request;
    }

    @Override
    public void register(RequestHandler handler) {
        this.handler = handler;
    }

    @Override
    public Message.Request request() {
        return this.request;
    }

    @Override
    public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
        try {
            block1 : switch (response.type) {
                case RESULT: {
                    Responses.Result rm = (Responses.Result)response;
                    switch (rm.kind) {
                        case SET_KEYSPACE: {
                            this.session.poolsState.setKeyspace(((Responses.Result.SetKeyspace)rm).keyspace);
                            this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            ArrayBackedResultSet rs = ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement);
                            final Cluster.Manager cluster = this.session.cluster.manager;
                            if (!cluster.configuration.getQueryOptions().isMetadataEnabled()) {
                                cluster.waitForSchemaAgreementAndSignal(connection, this, rs);
                                break block1;
                            }
                            Responses.Result.SchemaChange scc = (Responses.Result.SchemaChange)rm;
                            switch (scc.change) {
                                case CREATED: 
                                case UPDATED: {
                                    cluster.refreshSchemaAndSignal(connection, this, rs, scc.targetType, scc.targetKeyspace, scc.targetName, scc.targetSignature);
                                    break block1;
                                }
                                case DROPPED: {
                                    if (scc.targetType == SchemaElement.KEYSPACE) {
                                        final KeyspaceMetadata removedKeyspace = cluster.metadata.removeKeyspace(scc.targetKeyspace);
                                        if (removedKeyspace != null) {
                                            cluster.executor.submit(new Runnable(){

                                                @Override
                                                public void run() {
                                                    cluster.metadata.triggerOnKeyspaceRemoved(removedKeyspace);
                                                }
                                            });
                                        }
                                    } else {
                                        KeyspaceMetadata keyspace = (KeyspaceMetadata)this.session.cluster.manager.metadata.keyspaces.get(scc.targetKeyspace);
                                        if (keyspace == null) {
                                            logger.warn("Received a DROPPED notification for {} {}.{}, but this keyspace is unknown in our metadata", new Object[]{scc.targetType, scc.targetKeyspace, scc.targetName});
                                        } else {
                                            switch (scc.targetType) {
                                                case TABLE: {
                                                    final TableMetadata removedTable = keyspace.removeTable(scc.targetName);
                                                    if (removedTable != null) {
                                                        cluster.executor.submit(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                cluster.metadata.triggerOnTableRemoved(removedTable);
                                                            }
                                                        });
                                                        break;
                                                    }
                                                    final MaterializedViewMetadata removedView = keyspace.removeMaterializedView(scc.targetName);
                                                    if (removedView == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnMaterializedViewRemoved(removedView);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case TYPE: {
                                                    final UserType removedType = keyspace.removeUserType(scc.targetName);
                                                    if (removedType == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnUserTypeRemoved(removedType);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case FUNCTION: {
                                                    final FunctionMetadata removedFunction = keyspace.removeFunction(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedFunction == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnFunctionRemoved(removedFunction);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case AGGREGATE: {
                                                    final AggregateMetadata removedAggregate = keyspace.removeAggregate(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedAggregate == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnAggregateRemoved(removedAggregate);
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                    this.session.cluster.manager.waitForSchemaAgreementAndSignal(connection, this, rs);
                                    break block1;
                                }
                            }
                            logger.info("Ignoring unknown schema change result");
                            break block1;
                        }
                    }
                    this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                    break;
                }
                case ERROR: {
                    this.setException(((Responses.Error)response).asException(connection.address));
                    break;
                }
                default: {
                    connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                    this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                }
            }
        }
        catch (RuntimeException e) {
            this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
        }
    }

    @Override
    public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
        this.onSet(connection, response, null, null, latency);
    }

    @Override
    public void onException(Connection connection, Exception exception, long latency, int retryCount) {
        this.setException(exception);
    }

    @Override
    public boolean onTimeout(Connection connection, long latency, int retryCount) {
        this.setException(new OperationTimedOutException(connection.address));
        return true;
    }

    void setResult(ResultSet rs) {
        this.set(rs);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        if (this.handler != null) {
            this.handler.cancel();
        }
        return true;
    }

    @Override
    public int retryCount() {
        return 0;
    }
}

