/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.AbstractTableMetadata;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ClusteringOrder;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ColumnMetadata;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.DataTypeClassNameParser;
import shade.com.datastax.spark.connector.driver.core.DataTypeCqlNameParser;
import shade.com.datastax.spark.connector.driver.core.KeyspaceMetadata;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.Row;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.TableOptionsMetadata;
import shade.com.datastax.spark.connector.driver.core.VersionNumber;
import shade.com.datastax.spark.connector.google.common.base.Objects;

public class MaterializedViewMetadata
extends AbstractTableMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MaterializedViewMetadata.class);
    private final TableMetadata baseTable;
    private final boolean includeAllColumns;
    private final String whereClause;

    private MaterializedViewMetadata(KeyspaceMetadata keyspace, TableMetadata baseTable, String name, UUID id, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, Map<String, ColumnMetadata> columns, boolean includeAllColumns, String whereClause2, TableOptionsMetadata options, List<ClusteringOrder> clusteringOrder, VersionNumber cassandraVersion) {
        super(keyspace, name, id, partitionKey, clusteringColumns, columns, options, clusteringOrder, cassandraVersion);
        this.baseTable = baseTable;
        this.includeAllColumns = includeAllColumns;
        this.whereClause = whereClause2;
    }

    static MaterializedViewMetadata build(KeyspaceMetadata keyspace, Row row, Map<String, ColumnMetadata.Raw> rawCols, VersionNumber cassandraVersion, Cluster cluster) {
        String name = row.getString("view_name");
        String tableName = row.getString("base_table_name");
        TableMetadata baseTable = keyspace.tables.get(tableName);
        if (baseTable == null) {
            logger.trace(String.format("Cannot find base table %s for materialized view %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getView(\"%s\") will return null", tableName, keyspace.getName(), name, keyspace.getName(), name));
            return null;
        }
        UUID id = row.getUUID("id");
        boolean includeAllColumns = row.getBool("include_all_columns");
        String whereClause2 = row.getString("where_clause");
        int partitionKeySize = MaterializedViewMetadata.findCollectionSize(rawCols.values(), ColumnMetadata.Raw.Kind.PARTITION_KEY);
        int clusteringSize = MaterializedViewMetadata.findCollectionSize(rawCols.values(), ColumnMetadata.Raw.Kind.CLUSTERING_COLUMN);
        ArrayList<Object> partitionKey = new ArrayList<Object>(Collections.nCopies(partitionKeySize, null));
        ArrayList<Object> clusteringColumns = new ArrayList<Object>(Collections.nCopies(clusteringSize, null));
        ArrayList<Object> clusteringOrder = new ArrayList<Object>(Collections.nCopies(clusteringSize, null));
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        TableOptionsMetadata options = null;
        try {
            options = new TableOptionsMetadata(row, false, cassandraVersion);
        }
        catch (RuntimeException e) {
            logger.error(String.format("Error parsing schema options for view %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getView(\"%s\").getOptions() will return null", keyspace.getName(), name, keyspace.getName(), name), (Throwable)e);
        }
        MaterializedViewMetadata view = new MaterializedViewMetadata(keyspace, baseTable, name, id, partitionKey, clusteringColumns, columns, includeAllColumns, whereClause2, options, clusteringOrder, cassandraVersion);
        TreeSet<ColumnMetadata> otherColumns = new TreeSet<ColumnMetadata>(columnMetadataComparator);
        block6: for (ColumnMetadata.Raw raw : rawCols.values()) {
            DataType dataType;
            if (cassandraVersion.getMajor() >= 3) {
                dataType = DataTypeCqlNameParser.parse(raw.dataType, cluster, keyspace.getName(), keyspace.userTypes, keyspace.userTypes, false, false);
            } else {
                ProtocolVersion protocolVersion2 = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
                CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
                dataType = DataTypeClassNameParser.parseOne(raw.dataType, protocolVersion2, codecRegistry);
            }
            ColumnMetadata col = ColumnMetadata.fromRaw(view, raw, dataType);
            switch (raw.kind) {
                case PARTITION_KEY: {
                    partitionKey.set(raw.position, col);
                    continue block6;
                }
                case CLUSTERING_COLUMN: {
                    clusteringColumns.set(raw.position, col);
                    clusteringOrder.set(raw.position, (raw.isReversed ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                    continue block6;
                }
            }
            otherColumns.add(col);
        }
        for (ColumnMetadata columnMetadata : partitionKey) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : clusteringColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : otherColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        baseTable.add(view);
        return view;
    }

    private static int findCollectionSize(Collection<ColumnMetadata.Raw> cols, ColumnMetadata.Raw.Kind kind) {
        int maxId = -1;
        for (ColumnMetadata.Raw col : cols) {
            if (col.kind != kind) continue;
            maxId = Math.max(maxId, col.position);
        }
        return maxId + 1;
    }

    public TableMetadata getBaseTable() {
        return this.baseTable;
    }

    @Override
    protected String asCQLQuery(boolean formatted) {
        String keyspaceName = Metadata.escapeId(this.keyspace.getName());
        String baseTableName = Metadata.escapeId(this.baseTable.getName());
        String viewName = Metadata.escapeId(this.name);
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE MATERIALIZED VIEW ").append(keyspaceName).append('.').append(viewName).append(" AS ");
        MaterializedViewMetadata.newLine(sb, formatted);
        sb.append("SELECT ");
        if (this.includeAllColumns) {
            sb.append(" * ");
        } else {
            Iterator it = this.columns.values().iterator();
            while (it.hasNext()) {
                ColumnMetadata column = (ColumnMetadata)it.next();
                sb.append(MaterializedViewMetadata.spaces(4, formatted)).append(Metadata.escapeId(column.getName()));
                if (it.hasNext()) {
                    sb.append(",");
                }
                sb.append(" ");
                MaterializedViewMetadata.newLine(sb, formatted);
            }
        }
        MaterializedViewMetadata.newLine(sb.append("FROM ").append(keyspaceName).append('.').append(baseTableName).append(" "), formatted);
        if (this.whereClause != null && !this.whereClause.isEmpty()) {
            MaterializedViewMetadata.newLine(sb.append("WHERE ").append(this.whereClause).append(' '), formatted);
        }
        sb.append("PRIMARY KEY (");
        if (this.partitionKey.size() == 1) {
            sb.append(Metadata.escapeId(((ColumnMetadata)this.partitionKey.get(0)).getName()));
        } else {
            sb.append('(');
            boolean first = true;
            for (ColumnMetadata cm : this.partitionKey) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Metadata.escapeId(cm.getName()));
            }
            sb.append(')');
        }
        for (ColumnMetadata cm : this.clusteringColumns) {
            sb.append(", ").append(Metadata.escapeId(cm.getName()));
        }
        sb.append(')');
        this.appendOptions(sb, formatted);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MaterializedViewMetadata)) {
            return false;
        }
        MaterializedViewMetadata that = (MaterializedViewMetadata)other;
        return Objects.equal(this.name, that.name) && Objects.equal(this.id, that.id) && Objects.equal(this.partitionKey, that.partitionKey) && Objects.equal(this.clusteringColumns, that.clusteringColumns) && Objects.equal(this.columns, that.columns) && Objects.equal(this.options, that.options) && Objects.equal(this.clusteringOrder, that.clusteringOrder) && Objects.equal(this.baseTable.getName(), that.baseTable.getName()) && this.includeAllColumns == that.includeAllColumns;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.id, this.partitionKey, this.clusteringColumns, this.columns, this.options, this.clusteringOrder, this.baseTable.getName(), this.includeAllColumns);
    }
}

