/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class ParseUtils {
    private static final String[] iso8601Patterns = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd", "yyyy-MM-ddZ"};

    public static int skipSpaces(String toParse, int idx) {
        while (ParseUtils.isBlank(toParse.charAt(idx)) && idx < toParse.length()) {
            ++idx;
        }
        return idx;
    }

    public static int skipCQLValue(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        if (ParseUtils.isBlank(toParse.charAt(idx))) {
            throw new IllegalArgumentException();
        }
        int cbrackets = 0;
        int sbrackets = 0;
        int parens = 0;
        boolean inString = false;
        do {
            char c = toParse.charAt(idx);
            if (inString) {
                if (c != '\'') continue;
                if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\'') {
                    ++idx;
                    continue;
                }
                inString = false;
                if (cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == '\'') {
                inString = true;
                continue;
            }
            if (c == '{') {
                ++cbrackets;
                continue;
            }
            if (c == '[') {
                ++sbrackets;
                continue;
            }
            if (c == '(') {
                ++parens;
                continue;
            }
            if (c == '}') {
                if (cbrackets == 0) {
                    return idx;
                }
                if (--cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ']') {
                if (sbrackets == 0) {
                    return idx;
                }
                if (cbrackets != 0 || --sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ')') {
                if (parens == 0) {
                    return idx;
                }
                if (cbrackets != 0 || sbrackets != 0 || --parens != 0) continue;
                return idx + 1;
            }
            if (!ParseUtils.isBlank(c) && ParseUtils.isIdentifierChar(c) || cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
            return idx;
        } while (++idx < toParse.length());
        if (inString || cbrackets != 0 || sbrackets != 0 || parens != 0) {
            throw new IllegalArgumentException();
        }
        return idx;
    }

    public static int skipCQLId(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        char c = toParse.charAt(idx);
        if (ParseUtils.isIdentifierChar(c)) {
            while (idx < toParse.length() && ParseUtils.isIdentifierChar(toParse.charAt(idx))) {
                ++idx;
            }
            return idx;
        }
        if (c != '\"') {
            throw new IllegalArgumentException();
        }
        while (++idx < toParse.length()) {
            c = toParse.charAt(idx);
            if (c != '\"') continue;
            if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\"') {
                ++idx;
                continue;
            }
            return idx + 1;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    public static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    public static boolean isLongLiteral(String str2) {
        if (str2 == null || str2.isEmpty()) {
            return false;
        }
        char[] chars = str2.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ((c >= '0' || i == 0 && c == '-') && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isQuoted(String value2) {
        return value2 != null && value2.length() > 1 && value2.charAt(0) == '\'' && value2.charAt(value2.length() - 1) == '\'';
    }

    public static String quote(String value2) {
        return '\'' + ParseUtils.replaceChar(value2, '\'', "''") + '\'';
    }

    public static String unquote(String value2) {
        if (!ParseUtils.isQuoted(value2)) {
            return value2;
        }
        return value2.substring(1, value2.length() - 1).replace("''", "'");
    }

    public static Date parseDate(String str2) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        str2 = str2.replaceAll("(\\+|\\-)(\\d\\d):(\\d\\d)$", "$1$2$3");
        str2 = str2.replaceAll("Z$", "+0000");
        ParsePosition pos = new ParsePosition(0);
        for (String parsePattern : iso8601Patterns) {
            parser.applyPattern(parsePattern);
            pos.setIndex(0);
            Date date = parser.parse(str2, pos);
            if (date == null || pos.getIndex() != str2.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str2, -1);
    }

    public static Date parseDate(String str2, String pattern) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        str2 = str2.replaceAll("(\\+|\\-)(\\d\\d):(\\d\\d)$", "$1$2$3");
        str2 = str2.replaceAll("Z$", "+0000");
        ParsePosition pos = new ParsePosition(0);
        parser.applyPattern(pattern);
        pos.setIndex(0);
        Date date = parser.parse(str2, pos);
        if (date != null && pos.getIndex() == str2.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str2, -1);
    }

    public static long parseTime(String str2) throws ParseException {
        long second;
        long minute;
        long hour;
        long a_nanos = 0L;
        String formatError = "Timestamp format must be hh:mm:ss[.fffffffff]";
        String zeros = "000000000";
        if (str2 == null) {
            throw new IllegalArgumentException(formatError);
        }
        str2 = str2.trim();
        int firstColon = str2.indexOf(58);
        int secondColon = str2.indexOf(58, firstColon + 1);
        if (firstColon > 0 && secondColon > 0 && secondColon < str2.length() - 1) {
            int period = str2.indexOf(46, secondColon + 1);
            hour = Integer.parseInt(str2.substring(0, firstColon));
            if (hour < 0L || hour >= 24L) {
                throw new IllegalArgumentException("Hour out of bounds.");
            }
            minute = Integer.parseInt(str2.substring(firstColon + 1, secondColon));
            if (minute < 0L || minute >= 60L) {
                throw new IllegalArgumentException("Minute out of bounds.");
            }
            if (period > 0 && period < str2.length() - 1) {
                second = Integer.parseInt(str2.substring(secondColon + 1, period));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
                String nanos_s = str2.substring(period + 1);
                if (nanos_s.length() > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(nanos_s.charAt(0))) {
                    throw new IllegalArgumentException(formatError);
                }
                nanos_s = nanos_s + zeros.substring(0, 9 - nanos_s.length());
                a_nanos = Integer.parseInt(nanos_s);
            } else {
                if (period > 0) {
                    throw new ParseException(formatError, -1);
                }
                second = Integer.parseInt(str2.substring(secondColon + 1));
                if (second < 0L || second >= 60L) {
                    throw new ParseException("Second out of bounds.", -1);
                }
            }
        } else {
            throw new ParseException(formatError, -1);
        }
        long rawTime = 0L;
        rawTime += TimeUnit.HOURS.toNanos(hour);
        rawTime += TimeUnit.MINUTES.toNanos(minute);
        rawTime += TimeUnit.SECONDS.toNanos(second);
        return rawTime += a_nanos;
    }

    public static String formatTime(long value2) {
        int nano = (int)(value2 % 1000000000L);
        value2 -= (long)nano;
        int seconds = (int)((value2 /= 1000000000L) % 60L);
        value2 -= (long)seconds;
        int minutes = (int)((value2 /= 60L) % 60L);
        value2 -= (long)minutes;
        int hours = (int)((value2 /= 60L) % 24L);
        value2 -= (long)hours;
        assert ((value2 /= 24L) == 0L);
        StringBuilder sb = new StringBuilder();
        ParseUtils.leftPadZeros(hours, 2, sb);
        sb.append(":");
        ParseUtils.leftPadZeros(minutes, 2, sb);
        sb.append(":");
        ParseUtils.leftPadZeros(seconds, 2, sb);
        sb.append(".");
        ParseUtils.leftPadZeros(nano, 9, sb);
        return sb.toString();
    }

    private static String replaceChar(String text, char search, String replacement) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(search, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text;
        }
        int newLength = text.length() + nbMatch * (replacement.length() - 1);
        char[] result = new char[newLength];
        int newIdx = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == search) {
                for (int r = 0; r < replacement.length(); ++r) {
                    result[newIdx++] = replacement.charAt(r);
                }
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }

    private static void leftPadZeros(int value2, int digits, StringBuilder sb) {
        sb.append(String.format("%0" + digits + "d", value2));
    }

    private ParseUtils() {
    }
}

