/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;

class StreamIdGenerator {
    static final int MAX_STREAM_PER_CONNECTION_V2 = 128;
    static final int MAX_STREAM_PER_CONNECTION_V3 = 32768;
    private static final long MAX_UNSIGNED_LONG = -1L;
    private final AtomicLongArray bits;
    private final int maxIds;
    private final AtomicInteger offset;
    private final AtomicInteger marked = new AtomicInteger(0);

    static StreamIdGenerator newInstance(ProtocolVersion version) {
        return new StreamIdGenerator(StreamIdGenerator.streamIdSizeFor(version));
    }

    private static int streamIdSizeFor(ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return 1;
            }
            case V3: 
            case V4: {
                return 2;
            }
        }
        throw version.unsupported();
    }

    private StreamIdGenerator(int streamIdSizeInBytes) {
        this.maxIds = 1 << streamIdSizeInBytes * 8 - 1;
        assert (this.maxIds % 64 == 0);
        this.bits = new AtomicLongArray(this.maxIds / 64);
        for (int i = 0; i < this.bits.length(); ++i) {
            this.bits.set(i, -1L);
        }
        this.offset = new AtomicInteger(this.bits.length() - 1);
    }

    public int next() {
        int myOffset;
        int previousOffset;
        while (!this.offset.compareAndSet(previousOffset = this.offset.get(), myOffset = (previousOffset + 1) % this.bits.length())) {
        }
        for (int i = 0; i < this.bits.length(); ++i) {
            int j = (i + myOffset) % this.bits.length();
            int id = this.atomicGetAndSetFirstAvailable(j);
            if (id < 0) continue;
            return id + 64 * j;
        }
        return -1;
    }

    public void release(int streamId) {
        this.atomicClear(streamId / 64, streamId % 64);
    }

    public void mark(int streamId) {
        this.marked.incrementAndGet();
    }

    public void unmark(int streamId) {
        this.marked.decrementAndGet();
    }

    public int maxAvailableStreams() {
        return this.maxIds - this.marked.get();
    }

    private int atomicGetAndSetFirstAvailable(int idx) {
        int id;
        long l;
        do {
            if ((l = this.bits.get(idx)) != 0L) continue;
            return -1;
        } while (!this.bits.compareAndSet(idx, l, l ^ StreamIdGenerator.mask(id = Long.numberOfTrailingZeros(l))));
        return id;
    }

    private void atomicClear(int idx, int toClear) {
        long l;
        while (!this.bits.compareAndSet(idx, l = this.bits.get(idx), l | StreamIdGenerator.mask(toClear))) {
        }
    }

    private static long mask(int id) {
        return 1L << id;
    }
}

