/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import shade.com.datastax.spark.connector.driver.core.AbstractAddressableByIndexData;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.TupleType;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;

public class TupleValue
extends AbstractAddressableByIndexData<TupleValue> {
    private final TupleType type;

    TupleValue(TupleType type) {
        super(type.getProtocolVersion(), type.getComponentTypes().size());
        this.type = type;
    }

    @Override
    protected DataType getType(int i) {
        return this.type.getComponentTypes().get(i);
    }

    @Override
    protected String getName(int i) {
        return "component " + i;
    }

    @Override
    protected CodecRegistry getCodecRegistry() {
        return this.type.getCodecRegistry();
    }

    public TupleType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TupleValue)) {
            return false;
        }
        TupleValue that = (TupleValue)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TypeCodec<TupleValue> codec = this.getCodecRegistry().codecFor(this.type);
        sb.append(codec.format(this));
        return sb.toString();
    }
}

