/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;

public class ConnectionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    public final InetSocketAddress address;

    public ConnectionException(InetSocketAddress address, String msg, Throwable cause) {
        super(msg, cause);
        this.address = address;
    }

    public ConnectionException(InetSocketAddress address, String msg) {
        super(msg);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public String getMessage() {
        return String.format("[%s] %s", this.getHost(), this.getRawMessage());
    }

    @Override
    public ConnectionException copy() {
        return new ConnectionException(this.address, this.getRawMessage(), this);
    }

    String getRawMessage() {
        return super.getMessage();
    }
}

