/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;

public class ServerError
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public ServerError(InetSocketAddress address, String message) {
        super(String.format("An unexpected error occurred server side on %s: %s", address, message));
        this.address = address;
    }

    private ServerError(InetSocketAddress address, String message, ServerError cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public ServerError copy() {
        return new ServerError(this.address, this.getMessage(), this);
    }
}

