/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;

public class UnsupportedProtocolVersionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;
    private final ProtocolVersion unsupportedVersion;
    private final ProtocolVersion serverVersion;

    public UnsupportedProtocolVersionException(InetSocketAddress address, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion) {
        super(String.format("[%s] Host does not support protocol version %s but %s", new Object[]{address, unsupportedVersion, serverVersion}));
        this.address = address;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    public UnsupportedProtocolVersionException(InetSocketAddress address, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion, Throwable cause) {
        super(String.format("[%s] Host does not support protocol version %s but %s", new Object[]{address, unsupportedVersion, serverVersion}), cause);
        this.address = address;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public ProtocolVersion getUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    @Override
    public UnsupportedProtocolVersionException copy() {
        return new UnsupportedProtocolVersionException(this.address, this.unsupportedVersion, this.serverVersion, this);
    }
}

