/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.QueryConsistencyException;

public class WriteTimeoutException
extends QueryConsistencyException {
    private static final long serialVersionUID = 0L;
    private final WriteType writeType;

    public WriteTimeoutException(ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        this(null, consistency, writeType, received, required);
    }

    public WriteTimeoutException(InetSocketAddress address, ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(address, String.format("Cassandra timeout during write query at consistency %s (%d replica were required but only %d acknowledged the write)", new Object[]{consistency, required, received}), consistency, received, required);
        this.writeType = writeType;
    }

    private WriteTimeoutException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(address, msg, cause, consistency, received, required);
        this.writeType = writeType;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    @Override
    public WriteTimeoutException copy() {
        return new WriteTimeoutException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements());
    }

    public WriteTimeoutException copy(InetSocketAddress address) {
        return new WriteTimeoutException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements());
    }
}

