/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;
import shade.com.datastax.spark.connector.driver.core.policies.RetryPolicy;

public class DowngradingConsistencyRetryPolicy
implements RetryPolicy {
    public static final DowngradingConsistencyRetryPolicy INSTANCE = new DowngradingConsistencyRetryPolicy();

    private DowngradingConsistencyRetryPolicy() {
    }

    private RetryPolicy.RetryDecision maxLikelyToWorkCL(int knownOk) {
        if (knownOk >= 3) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.THREE);
        }
        if (knownOk == 2) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.TWO);
        }
        if (knownOk == 1) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.ONE);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (cl == ConsistencyLevel.SERIAL || cl == ConsistencyLevel.LOCAL_SERIAL) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (receivedResponses < requiredResponses) {
            return this.maxLikelyToWorkCL(receivedResponses);
        }
        return !dataRetrieved ? RetryPolicy.RetryDecision.retry(cl) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        switch (writeType) {
            case SIMPLE: 
            case BATCH: {
                return receivedAcks > 0 ? RetryPolicy.RetryDecision.ignore() : RetryPolicy.RetryDecision.rethrow();
            }
            case UNLOGGED_BATCH: {
                return this.maxLikelyToWorkCL(receivedAcks);
            }
            case BATCH_LOG: {
                return RetryPolicy.RetryDecision.retry(cl);
            }
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        return this.maxLikelyToWorkCL(aliveReplica);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
        return RetryPolicy.RetryDecision.tryNextHost(cl);
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }
}

