/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.QueryOptions;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;
import shade.com.datastax.spark.connector.driver.core.policies.RetryPolicy;

public class IdempotenceAwareRetryPolicy
implements RetryPolicy {
    private final RetryPolicy childPolicy;
    private QueryOptions queryOptions;

    public IdempotenceAwareRetryPolicy(RetryPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return this.childPolicy.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (this.isIdempotent(statement)) {
            return this.childPolicy.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return this.childPolicy.onUnavailable(statement, cl, requiredReplica, aliveReplica, nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
        if (this.isIdempotent(statement)) {
            return this.childPolicy.onRequestError(statement, cl, e, nbRetry);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public void init(Cluster cluster) {
        this.queryOptions = cluster.getConfiguration().getQueryOptions();
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }

    protected boolean isIdempotent(Statement statement) {
        Boolean myValue = statement.isIdempotent();
        if (myValue != null) {
            return myValue;
        }
        return this.queryOptions.getDefaultIdempotence();
    }
}

