/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import java.util.concurrent.atomic.AtomicInteger;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.PerHostPercentileTracker;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.policies.SpeculativeExecutionPolicy;
import shade.com.datastax.spark.connector.google.common.annotations.Beta;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;

@Beta
public class PercentileSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final PerHostPercentileTracker percentileTracker;
    private final double percentile;
    private final int maxSpeculativeExecutions;

    public PercentileSpeculativeExecutionPolicy(PerHostPercentileTracker percentileTracker, double percentile, int maxSpeculativeExecutions) {
        Preconditions.checkArgument(maxSpeculativeExecutions > 0, "number of speculative executions must be strictly positive (was %d)", maxSpeculativeExecutions);
        Preconditions.checkArgument(percentile >= 0.0 && percentile < 100.0, "percentile must be between 0.0 and 100 (was %f)");
        this.percentileTracker = percentileTracker;
        this.percentile = percentile;
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
        return new SpeculativeExecutionPolicy.SpeculativeExecutionPlan(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(PercentileSpeculativeExecutionPolicy.this.maxSpeculativeExecutions);
            }

            @Override
            public long nextExecution(Host lastQueried) {
                if (this.remaining.getAndDecrement() > 0) {
                    return PercentileSpeculativeExecutionPolicy.this.percentileTracker.getLatencyAtPercentile(lastQueried, PercentileSpeculativeExecutionPolicy.this.percentile);
                }
                return -1L;
            }
        };
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }
}

