/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import java.net.InetSocketAddress;
import java.util.Collection;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.policies.HostFilterPolicy;
import shade.com.datastax.spark.connector.driver.core.policies.LoadBalancingPolicy;
import shade.com.datastax.spark.connector.google.common.base.Predicate;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;

public class WhiteListPolicy
extends HostFilterPolicy {
    public WhiteListPolicy(LoadBalancingPolicy childPolicy, Collection<InetSocketAddress> whiteList) {
        super(childPolicy, WhiteListPolicy.buildPredicate(whiteList));
    }

    private static Predicate<Host> buildPredicate(Collection<InetSocketAddress> whiteList) {
        final ImmutableSet<InetSocketAddress> hosts2 = ImmutableSet.copyOf(whiteList);
        return new Predicate<Host>(){

            @Override
            public boolean apply(Host host) {
                return hosts2.contains(host.getSocketAddress());
            }
        };
    }
}

