/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.querybuilder;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ColumnMetadata;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.RegularStatement;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.exceptions.CodecNotFoundException;
import shade.com.datastax.spark.connector.driver.core.policies.RetryPolicy;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Utils;

public abstract class BuiltStatement
extends RegularStatement {
    private static final Pattern lowercaseId = Pattern.compile("[a-z][a-z0-9_]*");
    private final List<ColumnMetadata> partitionKey;
    private final List<Object> routingKeyValues;
    final String keyspace;
    private boolean dirty;
    private String cache;
    private List<Object> values;
    Boolean isCounterOp;
    boolean hasNonIdempotentOps;
    boolean hasBindMarkers;
    private boolean forceNoValues;

    BuiltStatement(String keyspace) {
        this.partitionKey = null;
        this.routingKeyValues = null;
        this.keyspace = keyspace;
    }

    BuiltStatement(TableMetadata tableMetadata) {
        this.partitionKey = tableMetadata.getPartitionKey();
        this.routingKeyValues = Arrays.asList(new Object[tableMetadata.getPartitionKey().size()]);
        this.keyspace = BuiltStatement.escapeId(tableMetadata.getKeyspace().getName());
    }

    protected static String escapeId(String ident) {
        return lowercaseId.matcher(ident).matches() ? ident : Metadata.quote(ident);
    }

    @Override
    public String getQueryString(CodecRegistry codecRegistry) {
        this.maybeRebuildCache(codecRegistry);
        return this.cache;
    }

    public Object getObject(int i, CodecRegistry codecRegistry) {
        this.maybeRebuildCache(codecRegistry);
        if (this.values == null || this.values.isEmpty()) {
            throw new IllegalStateException("This statement does not have values");
        }
        if (i < 0 || i >= this.values.size()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.values.get(i);
    }

    public Object getObject(int i) {
        return this.getObject(i, CodecRegistry.DEFAULT_INSTANCE);
    }

    private void maybeRebuildCache(CodecRegistry codecRegistry) {
        StringBuilder sb;
        if (!this.dirty && this.cache != null) {
            return;
        }
        this.values = null;
        if (this.hasBindMarkers || this.forceNoValues) {
            sb = this.buildQueryString(null, codecRegistry);
        } else {
            this.values = new ArrayList<Object>();
            sb = this.buildQueryString(this.values, codecRegistry);
            if (this.values.size() > 65535) {
                throw new IllegalArgumentException("Too many values for built statement, the maximum allowed is 65535");
            }
            if (this.values.isEmpty()) {
                this.values = null;
            }
        }
        BuiltStatement.maybeAddSemicolon(sb);
        this.cache = sb.toString();
        this.dirty = false;
    }

    static StringBuilder maybeAddSemicolon(StringBuilder sb) {
        int l;
        for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
        }
        if (l != sb.length()) {
            sb.setLength(l);
        }
        if (l == 0 || sb.charAt(l - 1) != ';') {
            sb.append(';');
        }
        return sb;
    }

    abstract StringBuilder buildQueryString(List<Object> var1, CodecRegistry var2);

    boolean isCounterOp() {
        return this.isCounterOp == null ? false : this.isCounterOp;
    }

    void setCounterOp(boolean isCounterOp) {
        this.isCounterOp = isCounterOp;
    }

    boolean hasNonIdempotentOps() {
        return this.hasNonIdempotentOps;
    }

    void setNonIdempotentOps() {
        this.hasNonIdempotentOps = true;
    }

    void checkForBindMarkers(Object value2) {
        this.dirty = true;
        if (Utils.containsBindMarker(value2)) {
            this.hasBindMarkers = true;
        }
    }

    void checkForBindMarkers(Utils.Appendeable value2) {
        this.dirty = true;
        if (value2 != null && value2.containsBindMarker()) {
            this.hasBindMarkers = true;
        }
    }

    void maybeAddRoutingKey(String name, Object value2) {
        if (this.routingKeyValues == null || name == null || value2 == null || Utils.containsSpecialValue(value2)) {
            return;
        }
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            if (!name.equals(this.partitionKey.get(i).getName())) continue;
            this.routingKeyValues.set(i, value2);
            return;
        }
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        if (this.routingKeyValues == null) {
            return null;
        }
        ByteBuffer[] routingKeyParts = new ByteBuffer[this.partitionKey.size()];
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            Object value2 = this.routingKeyValues.get(i);
            if (value2 == null) {
                return null;
            }
            TypeCodec<Object> codec = codecRegistry.codecFor(this.partitionKey.get(i).getType(), value2);
            routingKeyParts[i] = codec.serialize(value2, protocolVersion2);
        }
        return routingKeyParts.length == 1 ? routingKeyParts[0] : Utils.compose(routingKeyParts);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        this.maybeRebuildCache(codecRegistry);
        return this.values == null ? null : Utils.convert(this.values.toArray(), protocolVersion2, codecRegistry);
    }

    @Override
    public boolean hasValues(CodecRegistry codecRegistry) {
        this.maybeRebuildCache(codecRegistry);
        return this.values != null;
    }

    @Override
    public Map<String, ByteBuffer> getNamedValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        return null;
    }

    @Override
    public boolean usesNamedValues() {
        return false;
    }

    @Override
    public Boolean isIdempotent() {
        if (this.idempotent != null) {
            return this.idempotent;
        }
        return !this.hasNonIdempotentOps();
    }

    @Override
    public String toString() {
        try {
            if (this.forceNoValues) {
                return this.getQueryString();
            }
            StringBuilder queryString = this.buildQueryString(null, CodecRegistry.DEFAULT_INSTANCE);
            return BuiltStatement.maybeAddSemicolon(queryString).toString();
        }
        catch (CodecNotFoundException e) {
            return String.format("built query (could not generate with default codec registry: %s)", e.getMessage());
        }
    }

    public RegularStatement setForceNoValues(boolean forceNoValues) {
        this.forceNoValues = forceNoValues;
        this.dirty = true;
        return this;
    }

    static abstract class ForwardingStatement<T extends BuiltStatement>
    extends BuiltStatement {
        T statement;

        ForwardingStatement(T statement) {
            super((String)null);
            this.statement = statement;
        }

        @Override
        public String getQueryString(CodecRegistry codecRegistry) {
            return ((BuiltStatement)this.statement).getQueryString(codecRegistry);
        }

        @Override
        StringBuilder buildQueryString(List<Object> values, CodecRegistry codecRegistry) {
            return ((BuiltStatement)this.statement).buildQueryString(values, codecRegistry);
        }

        @Override
        public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
            return ((BuiltStatement)this.statement).getRoutingKey(protocolVersion2, codecRegistry);
        }

        @Override
        public String getKeyspace() {
            return ((BuiltStatement)this.statement).getKeyspace();
        }

        @Override
        boolean isCounterOp() {
            return ((BuiltStatement)this.statement).isCounterOp();
        }

        @Override
        boolean hasNonIdempotentOps() {
            return ((BuiltStatement)this.statement).hasNonIdempotentOps();
        }

        @Override
        public RegularStatement setForceNoValues(boolean forceNoValues) {
            ((BuiltStatement)this.statement).setForceNoValues(forceNoValues);
            return this;
        }

        @Override
        public Statement setConsistencyLevel(ConsistencyLevel consistency) {
            ((Statement)this.statement).setConsistencyLevel(consistency);
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            return ((Statement)this.statement).getConsistencyLevel();
        }

        @Override
        public Statement enableTracing() {
            ((Statement)this.statement).enableTracing();
            return this;
        }

        @Override
        public Statement disableTracing() {
            ((Statement)this.statement).disableTracing();
            return this;
        }

        @Override
        public boolean isTracing() {
            return ((Statement)this.statement).isTracing();
        }

        @Override
        public Statement setRetryPolicy(RetryPolicy policy) {
            ((Statement)this.statement).setRetryPolicy(policy);
            return this;
        }

        @Override
        public RetryPolicy getRetryPolicy() {
            return ((Statement)this.statement).getRetryPolicy();
        }

        @Override
        public ByteBuffer[] getValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
            return ((BuiltStatement)this.statement).getValues(protocolVersion2, codecRegistry);
        }

        @Override
        public boolean hasValues() {
            return ((RegularStatement)this.statement).hasValues();
        }

        @Override
        void checkForBindMarkers(Object value2) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value2);
        }

        @Override
        void checkForBindMarkers(Utils.Appendeable value2) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value2);
        }

        @Override
        public String toString() {
            return ((BuiltStatement)this.statement).toString();
        }
    }
}

